/*
 * Decompiled with CFR 0.152.
 */
package cascading;

import cascading.PlatformTestCase;
import cascading.flow.Flow;
import cascading.operation.Aggregator;
import cascading.operation.Filter;
import cascading.operation.Function;
import cascading.operation.Identity;
import cascading.operation.aggregator.Count;
import cascading.operation.expression.ExpressionFilter;
import cascading.operation.function.UnGroup;
import cascading.operation.regex.RegexFilter;
import cascading.operation.regex.RegexParser;
import cascading.operation.regex.RegexSplitter;
import cascading.pipe.CoGroup;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import data.InputData;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.junit.Test;

public class BasicPipesPlatformTest
extends PlatformTestCase {
    @Test
    public void testCount() throws Exception {
        this.runTestCount("count", new Fields(new Comparable[]{Integer.valueOf(1)}), new Fields(new Comparable[]{Integer.valueOf(0)}), new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)}));
    }

    @Test
    public void testCount2() throws Exception {
        this.runTestCount("count2", new Fields(new Comparable[]{Integer.valueOf(1)}), new Fields(new Comparable[]{"count"}), new Fields(new Comparable[]{Integer.valueOf(0), "count"}));
    }

    @Test
    public void testCount3() throws Exception {
        this.runTestCount("count3", new Fields(new Comparable[]{Integer.valueOf(1)}), new Fields(new Comparable[]{"count"}), Fields.ALL);
    }

    @Test
    public void testCount4() throws Exception {
        this.runTestCount("count4", Fields.ALL, new Fields(new Comparable[]{"count"}), Fields.ALL);
    }

    void runTestCount(String name, Fields argumentSelector, Fields fieldDeclaration, Fields outputSelector) throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileIps);
        Tap source = this.getPlatform().getTextFile(Fields.size((int)2), InputData.inputFileIps);
        Tap sink = this.getPlatform().getTextFile(Fields.size((int)1), this.getOutputPath(name), SinkMode.REPLACE);
        Pipe pipe = new Pipe("count");
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{Integer.valueOf(1)}));
        pipe = new Every(pipe, argumentSelector, (Aggregator)new Count(fieldDeclaration), outputSelector);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.start();
        flow.complete();
        BasicPipesPlatformTest.validateLength((Flow)flow, (int)17);
        BasicPipesPlatformTest.assertTrue((boolean)BasicPipesPlatformTest.getSinkAsList((Flow)flow).contains(new Tuple(new Object[]{"63.123.238.8\t2"})));
    }

    @Test
    public void testSimple() throws Exception {
        this.copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(Fields.size((int)2), InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(Fields.size((int)1), this.getOutputPath("simple"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        RegexParser parser = new RegexParser("^[^ ]*");
        pipe = new Each(pipe, new Fields(new Comparable[]{Integer.valueOf(1)}), (Function)parser, new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(2)}));
        pipe = new Each(pipe, new Fields(new Comparable[]{Integer.valueOf(1)}), (Function)new Identity());
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{Integer.valueOf(0)}));
        Count counter = new Count();
        pipe = new Every(pipe, new Fields(new Comparable[]{Integer.valueOf(0)}), (Aggregator)counter, new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)}));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        BasicPipesPlatformTest.validateLength((Flow)flow, (int)8, (int)1);
    }

    @Test
    public void testSimpleResult() throws Exception {
        this.copyFromLocal(InputData.inputFileLower);
        Tap source = this.getPlatform().getTextFile(Fields.size((int)2), InputData.inputFileLower);
        Tap sink = this.getPlatform().getTextFile(Fields.size((int)1), this.getOutputPath("simpleresult"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{Integer.valueOf(0)}), (Filter)new ExpressionFilter("$0 == 0", Long.class));
        pipe = new Each(pipe, new Fields(new Comparable[]{Integer.valueOf(1)}), (Function)new Identity());
        pipe = new Each(pipe, Fields.ALL, (Filter)new RegexFilter("a|b|c"));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{Integer.valueOf(0)}));
        Count counter = new Count();
        pipe = new Every(pipe, new Fields(new Comparable[]{Integer.valueOf(0)}), (Aggregator)counter, new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)}));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        BasicPipesPlatformTest.validateLength((Flow)flow, (int)2, (int)1);
    }

    @Test
    public void testSimpleRelative() throws Exception {
        this.copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(Fields.size((int)2), InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("simplerelative"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        RegexParser parser = new RegexParser("^[^ ]*");
        pipe = new Each(pipe, new Fields(new Comparable[]{Integer.valueOf(-1)}), (Function)parser, new Fields(new Comparable[]{Integer.valueOf(-1)}));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{Integer.valueOf(0)}));
        Count counter = new Count();
        pipe = new Every(pipe, new Fields(new Comparable[]{Integer.valueOf(0)}), (Aggregator)counter, new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)}));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        BasicPipesPlatformTest.validateLength((Flow)flow, (int)8);
    }

    @Test
    public void testSimpleRelativeUnknown() throws Exception {
        this.copyFromLocal(InputData.inputFileLower);
        Tap source = this.getPlatform().getDelimitedFile(Fields.UNKNOWN, " ", InputData.inputFileLower);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("simplerelativeunknown"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{Integer.valueOf(-1)}));
        Count counter = new Count();
        pipe = new Every(pipe, new Fields(new Comparable[]{Integer.valueOf(0)}), (Aggregator)counter, new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)}));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        BasicPipesPlatformTest.validateLength((Flow)flow, (int)5);
    }

    @Test
    public void testCoGroup() throws Exception {
        this.copyFromLocal(InputData.inputFileLower);
        Tap sourceLower = this.getPlatform().getTextFile(Fields.size((int)2), InputData.inputFileLower);
        Tap sourceUpper = this.getPlatform().getTextFile(Fields.size((int)2), InputData.inputFileUpper);
        HashMap<String, Tap> sources = new HashMap<String, Tap>();
        sources.put("lower", sourceLower);
        sources.put("upper", sourceUpper);
        Tap sink = this.getPlatform().getTextFile(Fields.size((int)1), this.getOutputPath("complexcogroup"), SinkMode.REPLACE);
        RegexSplitter splitter = new RegexSplitter(Fields.size((int)2), " ");
        Each pipeLower = new Each(new Pipe("lower"), new Fields(new Comparable[]{Integer.valueOf(1)}), (Function)splitter, Fields.RESULTS);
        Each pipeUpper = new Each(new Pipe("upper"), new Fields(new Comparable[]{Integer.valueOf(1)}), (Function)splitter, Fields.RESULTS);
        CoGroup splice = new CoGroup((Pipe)pipeLower, new Fields(new Comparable[]{Integer.valueOf(0)}), (Pipe)pipeUpper, new Fields(new Comparable[]{Integer.valueOf(0)}));
        Flow flow = this.getPlatform().getFlowConnector().connect(sources, sink, (Pipe)splice);
        flow.complete();
        BasicPipesPlatformTest.validateLength((Flow)flow, (int)5);
        List results = BasicPipesPlatformTest.getSinkAsList((Flow)flow);
        BasicPipesPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"1\ta\t1\tA"})));
        BasicPipesPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"2\tb\t2\tB"})));
    }

    @Test
    public void testCoGroupRelativeUnknown() throws Exception {
        this.copyFromLocal(InputData.inputFileLower);
        Tap sourceLower = this.getPlatform().getDelimitedFile(Fields.UNKNOWN, " ", InputData.inputFileLower);
        Tap sourceUpper = this.getPlatform().getDelimitedFile(Fields.UNKNOWN, " ", InputData.inputFileUpper);
        HashMap sources = new HashMap();
        sources.put("lower", sourceLower);
        sources.put("upper", sourceUpper);
        Tap sink = this.getPlatform().getTextFile(Fields.size((int)1), this.getOutputPath("complexcogrouprelativeunknown"), SinkMode.REPLACE);
        Pipe pipeLower = new Pipe("lower");
        Pipe pipeUpper = new Pipe("upper");
        CoGroup splice = new CoGroup(pipeLower, new Fields(new Comparable[]{Integer.valueOf(-2)}), pipeUpper, new Fields(new Comparable[]{Integer.valueOf(-2)}));
        Flow flow = this.getPlatform().getFlowConnector().connect(sources, sink, (Pipe)splice);
        flow.complete();
        BasicPipesPlatformTest.validateLength((Flow)flow, (int)5);
        List results = BasicPipesPlatformTest.getSinkAsList((Flow)flow);
        BasicPipesPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"1\ta\t1\tA"})));
        BasicPipesPlatformTest.assertTrue((boolean)results.contains(new Tuple(new Object[]{"2\tb\t2\tB"})));
    }

    @Test
    public void testUnGroup() throws Exception {
        this.copyFromLocal(InputData.inputFileJoined);
        Tap source = this.getPlatform().getTextFile(Fields.size((int)2), InputData.inputFileJoined);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("ungrouped"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        pipe = new Each(pipe, new Fields(new Comparable[]{Integer.valueOf(1)}), (Function)new RegexSplitter(Fields.size((int)3)));
        pipe = new Each(pipe, (Function)new UnGroup(Fields.size((int)2), new Fields(new Comparable[]{Integer.valueOf(0)}), Fields.fields((Fields[])new Fields[]{new Fields(new Comparable[]{Integer.valueOf(1)}), new Fields(new Comparable[]{Integer.valueOf(2)})})));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        BasicPipesPlatformTest.validateLength((Flow)flow, (int)10);
    }

    @Test
    public void testFilterAll() throws Exception {
        this.copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(Fields.size((int)2), InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("filterall"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        RegexFilter filter = new RegexFilter(".*", true);
        pipe = new Each(pipe, new Fields(new Comparable[]{Integer.valueOf(1)}), (Filter)filter);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        BasicPipesPlatformTest.validateLength((Flow)flow, (int)0);
    }

    @Test
    public void testFilter() throws Exception {
        this.copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(Fields.size((int)2), InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("filter"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        RegexFilter filter = new RegexFilter("^68.*");
        pipe = new Each(pipe, new Fields(new Comparable[]{Integer.valueOf(1)}), (Filter)filter);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        BasicPipesPlatformTest.validateLength((Flow)flow, (int)3);
    }

    @Test
    public void testSimpleChain() throws Exception {
        this.copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(Fields.size((int)2), InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("simplechain"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        RegexParser parser = new RegexParser("^[^ ]*");
        pipe = new Each(pipe, new Fields(new Comparable[]{Integer.valueOf(1)}), (Function)parser, new Fields(new Comparable[]{Integer.valueOf(2)}));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{Integer.valueOf(0)}));
        pipe = new Every(pipe, new Fields(new Comparable[]{Integer.valueOf(0)}), (Aggregator)new Count(), new Fields(new Comparable[]{Integer.valueOf(0), Integer.valueOf(1)}));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{Integer.valueOf(0)}));
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        BasicPipesPlatformTest.validateLength((Flow)flow, (int)8);
    }

    @Test
    public void testReplace() throws Exception {
        this.copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(Fields.size((int)2), InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("replace"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        RegexParser parser = new RegexParser(Fields.ARGS, "^[^ ]*");
        pipe = new Each(pipe, new Fields(new Comparable[]{Integer.valueOf(1)}), (Function)parser, Fields.REPLACE);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        BasicPipesPlatformTest.validateLength((Flow)flow, (int)10, (int)2, (Pattern)Pattern.compile("\\d+\\s\\d+\\s[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}"));
    }

    @Test
    public void testSwap() throws Exception {
        this.copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(Fields.size((int)2), InputData.inputFileApache);
        Tap sink = this.getPlatform().getTextFile(this.getOutputPath("swap"), SinkMode.REPLACE);
        Pipe pipe = new Pipe("test");
        RegexParser parser = new RegexParser(new Fields(new Comparable[]{Integer.valueOf(0)}), "^[^ ]*");
        pipe = new Each(pipe, new Fields(new Comparable[]{Integer.valueOf(1)}), (Function)parser, Fields.SWAP);
        Flow flow = this.getPlatform().getFlowConnector().connect(source, sink, pipe);
        flow.complete();
        BasicPipesPlatformTest.validateLength((Flow)flow, (int)10, (int)2, (Pattern)Pattern.compile("^\\d+\\s\\d+\\s[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}$"));
    }
}

