/*
 * Decompiled with CFR 0.152.
 */
package cascading.nested.json;

import cascading.CascadingTestCase;
import cascading.nested.json.JSONCoercibleType;
import cascading.nested.json.JSONGetFunction;
import cascading.operation.Function;
import cascading.operation.OperationException;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleListCollector;
import com.fasterxml.jackson.databind.node.TextNode;
import java.lang.reflect.Type;
import java.util.Collections;
import org.junit.Test;

public class JSONGetFunctionTest
extends CascadingTestCase {
    @Test
    public void testGet() {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        JSONGetFunction function = new JSONGetFunction(new Fields(new Comparable[]{"result"}), new String[]{"/person/name"});
        TupleListCollector result = JSONGetFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONGetFunctionTest.assertNotNull((Object)value);
        JSONGetFunctionTest.assertEquals((String)"John Doe", (String)((TextNode)value).textValue());
    }

    @Test
    public void testGetCoerced() {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        JSONGetFunction function = new JSONGetFunction(new Fields((Comparable)((Object)"result"), String.class), new String[]{"/person/name"});
        TupleListCollector result = JSONGetFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONGetFunctionTest.assertNotNull((Object)value);
        JSONGetFunctionTest.assertEquals((Object)"John Doe", (Object)value);
    }

    @Test
    public void testGetMissing() {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        JSONGetFunction function = new JSONGetFunction(new Fields(new Comparable[]{"result"}), new String[]{"/person/foobar"});
        TupleListCollector result = JSONGetFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONGetFunctionTest.assertNull((Object)value);
    }

    @Test(expected=OperationException.class)
    public void testGetMissingFail() {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        JSONGetFunction function = new JSONGetFunction(new Fields(new Comparable[]{"result"}), true, new String[]{"/person/foobar"});
        JSONGetFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
    }

    @Test
    public void testGetMap() {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        JSONGetFunction function = new JSONGetFunction(Collections.singletonMap(new Fields(new Comparable[]{"result"}), "/person/name"));
        TupleListCollector result = JSONGetFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONGetFunctionTest.assertNotNull((Object)value);
        JSONGetFunctionTest.assertEquals((String)"John Doe", (String)((TextNode)value).textValue());
    }
}

