/*
 * Decompiled with CFR 0.152.
 */
package cascading.nested.json;

import cascading.CascadingTestCase;
import cascading.nested.core.aggregate.AverageDoubleNestedAggregate;
import cascading.nested.core.aggregate.SimpleNestedAggregate;
import cascading.nested.core.aggregate.SumDoubleNestedAggregate;
import cascading.nested.core.aggregate.SumLongNestedAggregate;
import cascading.nested.json.JSONCoercibleType;
import cascading.nested.json.JSONGetAllAggregateFunction;
import cascading.operation.Function;
import cascading.operation.SerFunction;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleListCollector;
import com.fasterxml.jackson.databind.JsonNode;
import heretical.pointer.path.Pointer;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import org.junit.Test;

public class JSONGetAllAggregateFunctionTest
extends CascadingTestCase {
    @Test
    public void testGetAggregateSumLong() {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"people\":[ {\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"female\":false,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measures\": {\n    \"height\": 66,\n    \"weight\": 120\n}\n}},{\"person\":{\"name\":\"Jane Doe\",\"firstName\":\"Jane\",\"lastName\":\"Doe\",\"age\":49,\"female\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measures\": {\n    \"height\": 66,\n    \"weight\": 120\n}\n}},{\"person\":{\"name\":\"Jane Null\",\"firstName\":\"Jane\",\"lastName\":\"Null\",\"age\":null,\"female\":true,\"city\":\"Houston\",\"ssn\":null,\"measures\": {\n    \"height\": 66,\n    \"weight\": 120\n}\n}}]}");
        LinkedHashMap<String, SumLongNestedAggregate> pointerMap = new LinkedHashMap<String, SumLongNestedAggregate>();
        pointerMap.put("/person/age", new SumLongNestedAggregate(new Fields((Comparable)((Object)"sum"), Long.TYPE)));
        JSONGetAllAggregateFunction function = new JSONGetAllAggregateFunction("/people/*", pointerMap);
        TupleListCollector result = JSONGetAllAggregateFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JSONGetAllAggregateFunctionTest.assertEquals((int)1, (int)result.size());
        JSONGetAllAggregateFunctionTest.assertEquals((Object)99L, (Object)((Tuple)result.iterator().next()).getObject(0));
    }

    @Test
    public void testGetAggregateSumDouble() {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"people\":[ {\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"female\":false,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measures\": {\n    \"height\": 66,\n    \"weight\": 120\n}\n}},{\"person\":{\"name\":\"Jane Doe\",\"firstName\":\"Jane\",\"lastName\":\"Doe\",\"age\":49,\"female\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measures\": {\n    \"height\": 66,\n    \"weight\": 120\n}\n}},{\"person\":{\"name\":\"Jane Null\",\"firstName\":\"Jane\",\"lastName\":\"Null\",\"age\":null,\"female\":true,\"city\":\"Houston\",\"ssn\":null,\"measures\": {\n    \"height\": 66,\n    \"weight\": 120\n}\n}}]}");
        LinkedHashMap<String, SumDoubleNestedAggregate> pointerMap = new LinkedHashMap<String, SumDoubleNestedAggregate>();
        pointerMap.put("/person/age", new SumDoubleNestedAggregate(new Fields((Comparable)((Object)"sum"), Double.class)));
        JSONGetAllAggregateFunction function = new JSONGetAllAggregateFunction("/people/*", pointerMap);
        TupleListCollector result = JSONGetAllAggregateFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JSONGetAllAggregateFunctionTest.assertEquals((int)1, (int)result.size());
        JSONGetAllAggregateFunctionTest.assertEquals((Object)99.0, (Object)((Tuple)result.iterator().next()).getObject(0));
    }

    @Test
    public void testGetAggregateAverageDoubleAll() {
        this.runAverage((AverageDoubleNestedAggregate<JsonNode>)new AverageDoubleNestedAggregate(new Fields((Comparable)((Object)"avg"), Double.class)), 33.0);
    }

    @Test
    public void testGetAggregateAverageDoubleAllPrimitive() {
        this.runAverage((AverageDoubleNestedAggregate<JsonNode>)new AverageDoubleNestedAggregate(new Fields((Comparable)((Object)"avg"), Double.TYPE)), 33.0);
    }

    @Test
    public void testGetAggregateAverageDoubleNonNull() {
        this.runAverage((AverageDoubleNestedAggregate<JsonNode>)new AverageDoubleNestedAggregate(new Fields((Comparable)((Object)"avg"), Double.class), AverageDoubleNestedAggregate.Include.NO_NULLS), 49.5);
    }

    @Test
    public void testGetAggregateAverageDoubleNonNullPrimitive() {
        this.runAverage((AverageDoubleNestedAggregate<JsonNode>)new AverageDoubleNestedAggregate(new Fields((Comparable)((Object)"avg"), Double.TYPE), AverageDoubleNestedAggregate.Include.NO_NULLS), 49.5);
    }

    private void runAverage(AverageDoubleNestedAggregate<JsonNode> avg, double expected) {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"people\":[ {\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"female\":false,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measures\": {\n    \"height\": 66,\n    \"weight\": 120\n}\n}},{\"person\":{\"name\":\"Jane Doe\",\"firstName\":\"Jane\",\"lastName\":\"Doe\",\"age\":49,\"female\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measures\": {\n    \"height\": 66,\n    \"weight\": 120\n}\n}},{\"person\":{\"name\":\"Jane Null\",\"firstName\":\"Jane\",\"lastName\":\"Null\",\"age\":null,\"female\":true,\"city\":\"Houston\",\"ssn\":null,\"measures\": {\n    \"height\": 66,\n    \"weight\": 120\n}\n}}]}");
        LinkedHashMap<String, AverageDoubleNestedAggregate<JsonNode>> pointerMap = new LinkedHashMap<String, AverageDoubleNestedAggregate<JsonNode>>();
        pointerMap.put("/person/age", avg);
        JSONGetAllAggregateFunction function = new JSONGetAllAggregateFunction("/people/*", pointerMap);
        TupleListCollector result = JSONGetAllAggregateFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JSONGetAllAggregateFunctionTest.assertEquals((int)1, (int)result.size());
        JSONGetAllAggregateFunctionTest.assertEquals((Object)expected, (Object)((Tuple)result.iterator().next()).getObject(0));
    }

    @Test
    public void testGetAggregateFunction() {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"people\":[ {\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"female\":false,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measures\": {\n    \"height\": 66,\n    \"weight\": 120\n}\n}},{\"person\":{\"name\":\"Jane Doe\",\"firstName\":\"Jane\",\"lastName\":\"Doe\",\"age\":49,\"female\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measures\": {\n    \"height\": 66,\n    \"weight\": 120\n}\n}},{\"person\":{\"name\":\"Jane Null\",\"firstName\":\"Jane\",\"lastName\":\"Null\",\"age\":null,\"female\":true,\"city\":\"Houston\",\"ssn\":null,\"measures\": {\n    \"height\": 66,\n    \"weight\": 120\n}\n}}]}");
        LinkedHashMap<String, SimpleNestedAggregate> pointerMap = new LinkedHashMap<String, SimpleNestedAggregate>();
        SerFunction & Serializable factory = (SerFunction & Serializable)c -> new SimpleNestedAggregate.AggregateContext<JsonNode>(){
            final Tuple result;
            int count;
            double sum;
            final Pointer weightPointer;
            final Pointer heightPointer;
            {
                this.weightPointer = ((JSONCoercibleType)c).getNestedPointerCompiler().compile("/weight");
                this.heightPointer = ((JSONCoercibleType)c).getNestedPointerCompiler().compile("/height");
                this.result = Tuple.size((int)1);
                this.count = 0;
                this.sum = 0.0;
            }

            public void aggregate(JsonNode jsonNode) {
                long weight = ((JsonNode)this.weightPointer.at((Object)jsonNode)).asLong(-1L);
                long height = ((JsonNode)this.heightPointer.at((Object)jsonNode)).asLong(-1L);
                if (weight == -1L || height == -1L) {
                    return;
                }
                ++this.count;
                this.sum += (double)height / (double)weight;
            }

            public Tuple complete() {
                this.result.set(0, (Object)(this.sum / (double)this.count));
                return this.result;
            }

            public void reset() {
                this.count = 0;
                this.sum = 0.0;
            }
        };
        pointerMap.put("/person/measures", new SimpleNestedAggregate(new Fields((Comparable)((Object)"ratio"), Long.TYPE), (SerFunction)factory));
        JSONGetAllAggregateFunction function = new JSONGetAllAggregateFunction("/people/*", pointerMap);
        TupleListCollector result = JSONGetAllAggregateFunctionTest.invokeFunction((Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        JSONGetAllAggregateFunctionTest.assertEquals((int)1, (int)result.size());
        JSONGetAllAggregateFunctionTest.assertEquals((Object)0.55, (Object)((Tuple)result.iterator().next()).getObject(0));
    }
}

