/*
 * Decompiled with CFR 0.152.
 */
package cascading.nested.json;

import cascading.CascadingTestCase;
import cascading.nested.core.CopySpec;
import cascading.nested.json.JSONCoercibleType;
import cascading.nested.json.JSONCopyAsFunction;
import cascading.nested.json.JSONCopyIntoFunction;
import cascading.nested.json.filter.JSONBooleanPointerFilter;
import cascading.nested.json.filter.JSONStringPointerFilter;
import cascading.nested.json.transform.JSONPrimitiveTransforms;
import cascading.nested.json.transform.JSONSetTextTransform;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleListCollector;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Type;
import java.util.function.Function;
import java.util.function.Predicate;
import org.junit.Test;

public class JSONCopyIntoFunctionTest
extends CascadingTestCase {
    @Test
    public void testCopyInto() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE));
        TupleEntry entry = new TupleEntry(fields, Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"{ \"existing\":\"value\" }");
        CopySpec copySpec = (CopySpec)new CopySpec().from("/person");
        JSONCopyIntoFunction function = new JSONCopyIntoFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyIntoFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyIntoFunctionTest.assertNotNull((Object)value);
        JSONCopyIntoFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyIntoFunctionTest.assertEquals((String)"John Doe", (String)((ObjectNode)value).get("name").textValue());
        JSONCopyIntoFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).get("age").intValue());
        JSONCopyIntoFunctionTest.assertEquals((String)"123-45-6789", (String)((ObjectNode)value).get("ssn").textValue());
    }

    @Test
    public void testCopyIntoPredicate() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE));
        TupleEntry entry = new TupleEntry(fields, Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"{ \"existing\":\"value\" }");
        CopySpec copySpec = (CopySpec)new CopySpec().from("/person", (Predicate)new JSONStringPointerFilter("/name", "John Doe"));
        JSONCopyIntoFunction function = new JSONCopyIntoFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyIntoFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyIntoFunctionTest.assertNotNull((Object)value);
        JSONCopyIntoFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyIntoFunctionTest.assertEquals((String)"John Doe", (String)((ObjectNode)value).get("name").textValue());
        JSONCopyIntoFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).get("age").intValue());
        JSONCopyIntoFunctionTest.assertEquals((String)"123-45-6789", (String)((ObjectNode)value).get("ssn").textValue());
    }

    @Test
    public void testCopyIntoPredicateNegate() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE));
        TupleEntry entry = new TupleEntry(fields, Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"{ \"existing\":\"value\" }");
        CopySpec copySpec = (CopySpec)new CopySpec().from("/person", new JSONStringPointerFilter("/name", "John Doe").negate());
        JSONCopyIntoFunction function = new JSONCopyIntoFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyIntoFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyIntoFunctionTest.assertNotNull((Object)value);
        JSONCopyIntoFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyIntoFunctionTest.assertNull((Object)((ObjectNode)value).get("name"));
        JSONCopyIntoFunctionTest.assertNull((Object)((ObjectNode)value).get("age"));
        JSONCopyIntoFunctionTest.assertNull((Object)((ObjectNode)value).get("ssn"));
    }

    @Test
    public void testCopyIntoPredicateBoolean() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE));
        TupleEntry entry = new TupleEntry(fields, Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"{ \"existing\":\"value\" }");
        CopySpec copySpec = (CopySpec)new CopySpec().from("/person", (Predicate)new JSONBooleanPointerFilter("/human", true));
        JSONCopyIntoFunction function = new JSONCopyIntoFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyIntoFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyIntoFunctionTest.assertNotNull((Object)value);
        JSONCopyIntoFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyIntoFunctionTest.assertEquals((String)"John Doe", (String)((ObjectNode)value).get("name").textValue());
        JSONCopyIntoFunctionTest.assertEquals((boolean)true, (boolean)((ObjectNode)value).get("human").booleanValue());
        JSONCopyIntoFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).get("age").intValue());
        JSONCopyIntoFunctionTest.assertEquals((String)"123-45-6789", (String)((ObjectNode)value).get("ssn").textValue());
    }

    @Test
    public void testCopyIntoPredicateBooleanNegate() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE));
        TupleEntry entry = new TupleEntry(fields, Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"{ \"existing\":\"value\" }");
        CopySpec copySpec = (CopySpec)new CopySpec().from("/person", new JSONBooleanPointerFilter("/human", true).negate());
        JSONCopyIntoFunction function = new JSONCopyIntoFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyIntoFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyIntoFunctionTest.assertNotNull((Object)value);
        JSONCopyIntoFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyIntoFunctionTest.assertNull((Object)((ObjectNode)value).get("name"));
        JSONCopyIntoFunctionTest.assertNull((Object)((ObjectNode)value).get("human"));
        JSONCopyIntoFunctionTest.assertNull((Object)((ObjectNode)value).get("age"));
        JSONCopyIntoFunctionTest.assertNull((Object)((ObjectNode)value).get("ssn"));
    }

    @Test
    public void testCopyIntoArrayPredicate() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE));
        TupleEntry entry = new TupleEntry(fields, Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"people\":[ {\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"female\":false,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}},{\"person\":{\"name\":\"Jane Doe\",\"firstName\":\"Jane\",\"lastName\":\"Doe\",\"age\":49,\"female\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}}]}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"{ \"existing\":\"value\" }");
        CopySpec copySpec = (CopySpec)new CopySpec().from("/people/*", (Predicate)new JSONStringPointerFilter("/person/name", "John Doe"));
        JSONCopyIntoFunction function = new JSONCopyIntoFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyIntoFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyIntoFunctionTest.assertNotNull((Object)value);
        JSONCopyIntoFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyIntoFunctionTest.assertEquals((String)"John Doe", (String)((ObjectNode)value).get("person").get("name").textValue());
        JSONCopyIntoFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).get("person").get("age").intValue());
        JSONCopyIntoFunctionTest.assertEquals((String)"123-45-6789", (String)((ObjectNode)value).get("person").get("ssn").textValue());
    }

    @Test
    public void testCopyIntoArrayPredicateNegate() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE));
        TupleEntry entry = new TupleEntry(fields, Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"people\":[ {\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"female\":false,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}},{\"person\":{\"name\":\"Jane Doe\",\"firstName\":\"Jane\",\"lastName\":\"Doe\",\"age\":49,\"female\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}}]}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"{ \"existing\":\"value\" }");
        CopySpec copySpec = (CopySpec)new CopySpec().from("/people/*", new JSONStringPointerFilter("/person/name", "John Doe").negate());
        JSONCopyIntoFunction function = new JSONCopyIntoFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyIntoFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyIntoFunctionTest.assertNotNull((Object)value);
        JSONCopyIntoFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyIntoFunctionTest.assertEquals((String)"Jane Doe", (String)((ObjectNode)value).get("person").get("name").textValue());
        JSONCopyIntoFunctionTest.assertEquals((int)49, (int)((ObjectNode)value).get("person").get("age").intValue());
        JSONCopyIntoFunctionTest.assertEquals((String)"123-45-6789", (String)((ObjectNode)value).get("person").get("ssn").textValue());
    }

    @Test
    public void testCopyIntoInto() throws Exception {
        TupleEntry entry = new TupleEntry(new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE), Tuple.size((int)1));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"people\":[ {\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"female\":false,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}},{\"person\":{\"name\":\"Jane Doe\",\"firstName\":\"Jane\",\"lastName\":\"Doe\",\"age\":49,\"female\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\"}}]}");
        CopySpec copySpec = (CopySpec)new CopySpec("/people").from("/people/0");
        JSONCopyAsFunction function = new JSONCopyAsFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyIntoFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyIntoFunctionTest.assertNotNull((Object)value);
        value = ((ObjectNode)value).get("people").get("person");
        JSONCopyIntoFunctionTest.assertEquals((String)"John Doe", (String)((ObjectNode)value).get("name").textValue());
        JSONCopyIntoFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).get("age").intValue());
        JSONCopyIntoFunctionTest.assertEquals((String)"123-45-6789", (String)((ObjectNode)value).get("ssn").textValue());
    }

    @Test
    public void testCopyIncludeFrom() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE));
        TupleEntry entry = new TupleEntry(fields, Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"{ \"existing\":\"value\" }");
        CopySpec copySpec = (CopySpec)((CopySpec)new CopySpec().fromInclude("/person", new String[]{"/firstName"})).fromInclude("/person", new String[]{"/age"});
        JSONCopyIntoFunction function = new JSONCopyIntoFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyIntoFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyIntoFunctionTest.assertNotNull((Object)value);
        JSONCopyIntoFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyIntoFunctionTest.assertEquals((String)"John", (String)((ObjectNode)value).get("firstName").textValue());
        JSONCopyIntoFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).get("age").intValue());
        JSONCopyIntoFunctionTest.assertEquals(null, (Object)((ObjectNode)value).get("ssn"));
    }

    @Test
    public void testCopyIncludeFromPredicate() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE));
        TupleEntry entry = new TupleEntry(fields, Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"{ \"existing\":\"value\" }");
        CopySpec copySpec = (CopySpec)((CopySpec)new CopySpec().fromInclude("/person", "/firstName", new JSONStringPointerFilter("John").negate())).fromInclude("/person", new String[]{"/age"});
        JSONCopyIntoFunction function = new JSONCopyIntoFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyIntoFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyIntoFunctionTest.assertNotNull((Object)value);
        JSONCopyIntoFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyIntoFunctionTest.assertNull((Object)((ObjectNode)value).get("firstName"));
        JSONCopyIntoFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).get("age").intValue());
        JSONCopyIntoFunctionTest.assertEquals(null, (Object)((ObjectNode)value).get("ssn"));
    }

    @Test
    public void testCopyInclude() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE));
        TupleEntry entry = new TupleEntry(fields, Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"{ \"existing\":\"value\" }");
        CopySpec copySpec = (CopySpec)((CopySpec)new CopySpec().include(new String[]{"/person/firstName"})).include(new String[]{"/person/age"});
        JSONCopyIntoFunction function = new JSONCopyIntoFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyIntoFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyIntoFunctionTest.assertNotNull((Object)value);
        JSONCopyIntoFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyIntoFunctionTest.assertEquals((String)"John", (String)((ObjectNode)value).findPath("firstName").textValue());
        JSONCopyIntoFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).findPath("age").intValue());
        JSONCopyIntoFunctionTest.assertEquals(null, (Object)((ObjectNode)value).findValue("ssn"));
    }

    @Test
    public void testCopyIncludeWild() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE));
        TupleEntry entry = new TupleEntry(fields, Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"{ \"existing\":\"value\" }");
        CopySpec copySpec = (CopySpec)((CopySpec)new CopySpec().include(new String[]{"/person/firstName"})).include(new String[]{"/*/age"});
        JSONCopyIntoFunction function = new JSONCopyIntoFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyIntoFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyIntoFunctionTest.assertNotNull((Object)value);
        JSONCopyIntoFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyIntoFunctionTest.assertEquals((String)"John", (String)((ObjectNode)value).findPath("firstName").textValue());
        JSONCopyIntoFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).findPath("age").intValue());
        JSONCopyIntoFunctionTest.assertEquals(null, (Object)((ObjectNode)value).findValue("ssn"));
    }

    @Test
    public void testCopyIncludeDescent() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE));
        TupleEntry entry = new TupleEntry(fields, Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"{ \"existing\":\"value\" }");
        CopySpec copySpec = (CopySpec)((CopySpec)new CopySpec().include(new String[]{"/person/firstName"})).include(new String[]{"/**/age"});
        JSONCopyIntoFunction function = new JSONCopyIntoFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyIntoFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyIntoFunctionTest.assertNotNull((Object)value);
        JSONCopyIntoFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyIntoFunctionTest.assertEquals((String)"John", (String)((ObjectNode)value).findPath("firstName").textValue());
        JSONCopyIntoFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).findPath("age").intValue());
        JSONCopyIntoFunctionTest.assertEquals(null, (Object)((ObjectNode)value).findValue("ssn"));
    }

    @Test
    public void testCopyIncludeFrom2() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE));
        TupleEntry entry = new TupleEntry(fields, Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"{ \"existing\":\"value\" }");
        CopySpec copySpec = (CopySpec)new CopySpec().fromInclude("/person", new String[]{"/firstName", "/age"});
        JSONCopyIntoFunction function = new JSONCopyIntoFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyIntoFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyIntoFunctionTest.assertNotNull((Object)value);
        JSONCopyIntoFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyIntoFunctionTest.assertEquals((String)"John", (String)((ObjectNode)value).get("firstName").textValue());
        JSONCopyIntoFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).get("age").intValue());
        JSONCopyIntoFunctionTest.assertEquals(null, (Object)((ObjectNode)value).get("ssn"));
    }

    @Test
    public void testCopyExcludeFrom() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE));
        TupleEntry entry = new TupleEntry(fields, Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"{ \"existing\":\"value\" }");
        CopySpec copySpec = (CopySpec)new CopySpec().fromExclude("/person", new String[]{"/ssn", "/children"});
        JSONCopyIntoFunction function = new JSONCopyIntoFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyIntoFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyIntoFunctionTest.assertNotNull((Object)value);
        JSONCopyIntoFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyIntoFunctionTest.assertEquals((String)"John Doe", (String)((ObjectNode)value).get("name").textValue());
        JSONCopyIntoFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).get("age").intValue());
        JSONCopyIntoFunctionTest.assertEquals(null, (Object)((ObjectNode)value).get("ssn"));
        JSONCopyIntoFunctionTest.assertEquals(null, (Object)((ObjectNode)value).get("children"));
    }

    @Test
    public void testCopyExclude() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE));
        TupleEntry entry = new TupleEntry(fields, Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"{ \"existing\":\"value\" }");
        CopySpec copySpec = (CopySpec)new CopySpec().exclude(new String[]{"/person/ssn", "/person/children"});
        JSONCopyIntoFunction function = new JSONCopyIntoFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyIntoFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyIntoFunctionTest.assertNotNull((Object)value);
        JSONCopyIntoFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyIntoFunctionTest.assertEquals((String)"John Doe", (String)((ObjectNode)value).findPath("name").textValue());
        JSONCopyIntoFunctionTest.assertEquals((int)50, (int)((ObjectNode)value).findPath("age").intValue());
        JSONCopyIntoFunctionTest.assertEquals(null, (Object)((ObjectNode)value).findValue("ssn"));
        JSONCopyIntoFunctionTest.assertEquals(null, (Object)((ObjectNode)value).findValue("children"));
    }

    @Test
    public void testCopyExcludeDescent() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE));
        TupleEntry entry = new TupleEntry(fields, Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"{ \"existing\":\"value\" }");
        CopySpec copySpec = (CopySpec)new CopySpec().exclude(new String[]{"/**/value"});
        JSONCopyIntoFunction function = new JSONCopyIntoFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyIntoFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyIntoFunctionTest.assertNotNull((Object)value);
        JSONCopyIntoFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyIntoFunctionTest.assertNotNull((Object)((ObjectNode)value).get("person"));
        value = ((ObjectNode)value).get("person");
        JSONCopyIntoFunctionTest.assertNull((Object)((ObjectNode)value).get("measure").get("value"));
    }

    @Test
    public void testCoerce() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE));
        TupleEntry entry = new TupleEntry(fields, Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"{ \"existing\":\"value\" }");
        CopySpec copySpec = (CopySpec)new CopySpec().fromTransform("/person/measure", "/value", (Function)JSONPrimitiveTransforms.TO_FLOAT);
        JSONCopyIntoFunction function = new JSONCopyIntoFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyIntoFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyIntoFunctionTest.assertNotNull((Object)value);
        JSONCopyIntoFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyIntoFunctionTest.assertEquals((Object)JsonNodeType.NUMBER, (Object)((ObjectNode)value).get("value").getNodeType());
        JSONCopyIntoFunctionTest.assertEquals(FloatNode.class, ((ObjectNode)value).get("value").getClass());
        JSONCopyIntoFunctionTest.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(((ObjectNode)value).get("value").floatValue()));
    }

    @Test
    public void testCoerceZero() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE));
        TupleEntry entry = new TupleEntry(fields, Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"{ \"existing\":\"value\" }");
        CopySpec copySpec = (CopySpec)new CopySpec().fromTransform("/person/zero", "/zeroValue", (Function)JSONPrimitiveTransforms.TO_FLOAT);
        JSONCopyIntoFunction function = new JSONCopyIntoFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyIntoFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyIntoFunctionTest.assertNotNull((Object)value);
        JSONCopyIntoFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyIntoFunctionTest.assertEquals((Object)JsonNodeType.NUMBER, (Object)((ObjectNode)value).get("zeroValue").getNodeType());
        JSONCopyIntoFunctionTest.assertEquals(FloatNode.class, ((ObjectNode)value).get("zeroValue").getClass());
        JSONCopyIntoFunctionTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(((ObjectNode)value).get("zeroValue").floatValue()));
        JSONCopyIntoFunctionTest.assertEquals((String)"0.0", (String)((ObjectNode)value).get("zeroValue").asText());
    }

    @Test
    public void testCoerceArray() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE));
        TupleEntry entry = new TupleEntry(fields, Tuple.size((int)2));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"{ \"existing\":\"value\" }");
        CopySpec copySpec = (CopySpec)new CopySpec().fromTransform("/person", "/measures/*/value", (Function)JSONPrimitiveTransforms.TO_FLOAT);
        JSONCopyIntoFunction function = new JSONCopyIntoFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        TupleListCollector result = JSONCopyIntoFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyIntoFunctionTest.assertNotNull((Object)value);
        JSONCopyIntoFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyIntoFunctionTest.assertEquals((Object)JsonNodeType.ARRAY, (Object)((ObjectNode)value).get("measures").getNodeType());
        JSONCopyIntoFunctionTest.assertEquals(FloatNode.class, ((ObjectNode)value).get("measures").get(0).get("value").getClass());
        JSONCopyIntoFunctionTest.assertEquals((Object)Float.valueOf(1000.0f), (Object)Float.valueOf(((ObjectNode)value).get("measures").get(0).get("value").floatValue()));
        JSONCopyIntoFunctionTest.assertEquals(FloatNode.class, ((ObjectNode)value).get("measures").get(1).get("value").getClass());
        JSONCopyIntoFunctionTest.assertEquals((Object)Float.valueOf(2000.0f), (Object)Float.valueOf(((ObjectNode)value).get("measures").get(1).get("value").floatValue()));
    }

    @Test
    public void testResettableTransform() throws Exception {
        Fields fields = new Fields((Comparable)((Object)"json"), (Type)JSONCoercibleType.TYPE).append(new Fields((Comparable)((Object)"set-text"), String.class)).append(new Fields((Comparable)((Object)"result"), (Type)JSONCoercibleType.TYPE));
        TupleEntry entry = new TupleEntry(fields, Tuple.size((int)3));
        entry.setObject((Comparable)Integer.valueOf(0), (Object)"{\"person\":{\"name\":\"John Doe\",\"firstName\":\"John\",\"lastName\":\"Doe\",\"age\":50,\"human\":true,\"city\":\"Houston\",\"ssn\":\"123-45-6789\",\"measure\": { \"value\":100 },\"measures\":[ { \"value\":1000 }, { \"value\":2000 } ],\"measured\":[ 1000, 2000 ],\"children\":[\"Jane\",\"June\",\"Josh\"],\"arrays\":[[\"Jane1\",\"June1\",\"Josh1\"],[\"Jane2\",\"June2\",\"Josh2\"]],\"zero\": { \"zeroValue\":0 }}}");
        entry.setObject((Comparable)Integer.valueOf(2), (Object)"{ \"existing\":\"value\" }");
        CopySpec copySpec = (CopySpec)new CopySpec().fromTransform("/person", "/name", (Function)new JSONSetTextTransform("set-text", "value1"));
        JSONCopyIntoFunction function = new JSONCopyIntoFunction(new Fields(new Comparable[]{"result"}), new CopySpec[]{copySpec});
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"value2");
        TupleListCollector result = JSONCopyIntoFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        Object value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyIntoFunctionTest.assertNotNull((Object)value);
        JSONCopyIntoFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyIntoFunctionTest.assertEquals((String)"value2", (String)((ObjectNode)value).get("name").textValue());
        entry.setObject((Comparable)Integer.valueOf(1), (Object)"value3");
        result = JSONCopyIntoFunctionTest.invokeFunction((cascading.operation.Function)function, (TupleEntry)entry, (Fields)new Fields(new Comparable[]{"result"}));
        value = ((Tuple)result.iterator().next()).getObject(0);
        JSONCopyIntoFunctionTest.assertNotNull((Object)value);
        JSONCopyIntoFunctionTest.assertEquals((String)"value", (String)((ObjectNode)value).get("existing").textValue());
        JSONCopyIntoFunctionTest.assertEquals((String)"value3", (String)((ObjectNode)value).get("name").textValue());
    }
}

