/*
 * Decompiled with CFR 0.152.
 */
package cascading.local.tap.splunk;

import cascading.flow.FlowProcess;
import cascading.local.tap.splunk.SplunkScheme;
import cascading.local.tap.splunk.SplunkTap;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntryCollector;
import com.splunk.JobExportArgs;
import com.splunk.Service;
import com.splunk.ServiceArgs;
import java.io.OutputStream;
import java.util.Properties;

public class SplunkSearchTap
extends SplunkTap {
    private String search;

    public SplunkSearchTap(SplunkScheme scheme, String host, int port, String search) {
        super(scheme, host, port);
        this.search = search;
    }

    public SplunkSearchTap(SplunkScheme scheme, ServiceArgs serviceArgs, String search) {
        super(scheme, serviceArgs);
        this.search = search;
    }

    public SplunkSearchTap(SplunkScheme scheme, ServiceArgs serviceArgs, JobExportArgs exportArgs, String search) {
        super(scheme, serviceArgs, exportArgs);
        this.search = search;
    }

    public SplunkSearchTap(SplunkScheme scheme, Service service, String search) {
        super(scheme, service, null);
        this.search = search;
    }

    @Override
    protected String getSplunkQuery() {
        return this.search;
    }

    @Override
    protected String getSplunkPath() {
        return "/";
    }

    @Override
    protected String getSearch() {
        return String.format("search %s", this.search);
    }

    public Fields getSinkFields() {
        throw new UnsupportedOperationException("unable to sink tuple streams via a SourceTap instance");
    }

    public final boolean isSink() {
        return false;
    }

    public boolean deleteResource(Properties conf) {
        throw new UnsupportedOperationException("unable to delete files via a SourceTap instance");
    }

    public void sinkConfInit(FlowProcess<? extends Properties> flowProcess, Properties conf) {
        throw new UnsupportedOperationException("unable to source tuple streams via a SourceTap instance");
    }

    public boolean prepareResourceForWrite(Properties conf) {
        throw new UnsupportedOperationException("unable to prepare resource for write via a SourceTap instance");
    }

    public boolean createResource(Properties conf) {
        throw new UnsupportedOperationException("unable to make dirs via a SourceTap instance");
    }

    public boolean commitResource(Properties conf) {
        throw new UnsupportedOperationException("unable to commit resource via a SourceTap instance");
    }

    public boolean rollbackResource(Properties conf) {
        throw new UnsupportedOperationException("unable to rollback resource via a SourceTap instance");
    }

    public boolean resourceExists(Properties conf) {
        return true;
    }

    public long getModifiedTime(Properties conf) {
        return Long.MAX_VALUE;
    }

    public TupleEntryCollector openForWrite(FlowProcess<? extends Properties> flowProcess, OutputStream output) {
        throw new UnsupportedOperationException("unable to open for write via a SourceTap instance");
    }
}

