/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop;

import cascading.CascadingTestCase;
import cascading.tuple.Tuple;
import cascading.tuple.hadoop.TestWritableComparable;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.tuple.hadoop.io.HadoopTupleInputStream;
import cascading.tuple.hadoop.io.HadoopTupleOutputStream;
import cascading.tuple.io.TupleInputStream;
import cascading.tuple.io.TupleOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Test;

public class TupleTest
extends CascadingTestCase {
    @Test
    public void testWritableCompareReadWrite() throws IOException {
        Tuple aTuple = new Tuple(new Object[]{new TestWritableComparable("Just My Luck"), "ClaudiaPuig", "3.0", "LisaRose", "3.0", true});
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        HadoopTupleOutputStream dataOutputStream = new HadoopTupleOutputStream((OutputStream)byteArrayOutputStream, (TupleOutputStream.ElementWriter)new TupleSerialization().getElementWriter());
        dataOutputStream.writeTuple(aTuple);
        dataOutputStream.flush();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        HadoopTupleInputStream dataInputStream = new HadoopTupleInputStream((InputStream)byteArrayInputStream, (TupleInputStream.ElementReader)new TupleSerialization().getElementReader());
        Tuple newTuple = new Tuple();
        dataInputStream.readTuple(newTuple);
        TupleTest.assertEquals((Object)aTuple, (Object)newTuple);
    }

    @Test
    public void testWritableCompare() {
        Tuple aTuple = new Tuple(new Object[]{new TestWritableComparable("Just My Luck"), "ClaudiaPuig", "3.0", "LisaRose", "3.0"});
        Tuple bTuple = new Tuple(new Object[]{new TestWritableComparable("Just My Luck"), "ClaudiaPuig", "3.0", "LisaRose", "3.0"});
        TupleTest.assertEquals((String)"not equal: aTuple", (Object)bTuple, (Object)aTuple);
        TupleTest.assertTrue((String)"not equal than: aTuple = bTuple", (aTuple.compareTo(bTuple) == 0 ? 1 : 0) != 0);
        bTuple = new Tuple(new Object[]{new TestWritableComparable("Just My Luck"), "ClaudiaPuig", "3.0", "LisaRose", "2.0"});
        TupleTest.assertTrue((String)"not less than: aTuple < bTuple", (aTuple.compareTo(bTuple) > 0 ? 1 : 0) != 0);
    }
}

