/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop;

import cascading.tuple.Comparison;
import cascading.tuple.hadoop.SerializationToken;
import cascading.tuple.hadoop.TestText;
import cascading.tuple.hadoop.TestTextComparator;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

@SerializationToken(tokens={222}, classNames={"cascading.tuple.hadoop.TestText"})
public class TestSerialization
extends Configured
implements Comparison<TestText>,
Serialization<TestText> {
    public boolean accept(Class<?> c) {
        return TestText.class.isAssignableFrom(c);
    }

    public Serializer<TestText> getSerializer(Class<TestText> c) {
        return new TestTextSerializer();
    }

    public Deserializer<TestText> getDeserializer(Class<TestText> c) {
        return new TestTextDeserializer();
    }

    public Comparator<TestText> getComparator(Class<TestText> type) {
        return new TestTextComparator();
    }

    public static class TestTextSerializer
    implements Serializer<TestText> {
        private DataOutputStream out;

        public void open(OutputStream out) throws IOException {
            this.out = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
        }

        public void serialize(TestText testText) throws IOException {
            WritableUtils.writeString((DataOutput)this.out, (String)testText.value);
        }

        public void close() throws IOException {
            this.out.close();
        }
    }

    public static class TestTextDeserializer
    implements Deserializer<TestText> {
        private DataInputStream in;

        public void open(InputStream in) throws IOException {
            this.in = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        }

        public TestText deserialize(TestText testText) throws IOException {
            return new TestText(WritableUtils.readString((DataInput)this.in));
        }

        public void close() throws IOException {
            this.in.close();
        }
    }
}

