/*
 * Decompiled with CFR 0.152.
 */
package cascading.scheme.hadoop;

import cascading.PlatformTestCase;
import cascading.cascade.Cascade;
import cascading.cascade.CascadeConnector;
import cascading.flow.Flow;
import cascading.operation.Function;
import cascading.operation.expression.ExpressionFunction;
import cascading.pipe.Each;
import cascading.pipe.Pipe;
import cascading.scheme.Scheme;
import cascading.scheme.hadoop.TextLine;
import cascading.scheme.hadoop.WritableSequenceFile;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tap.hadoop.Hfs;
import cascading.tuple.Fields;
import data.InputData;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.junit.Test;

public class WritableSequenceFilePlatformTest
extends PlatformTestCase {
    public WritableSequenceFilePlatformTest() {
        super(true);
    }

    @Test
    public void testWritable() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Hfs source = new Hfs((Scheme)new TextLine(new Fields(new Comparable[]{"offset", "line"})), InputData.inputFileApache);
        Pipe pipe = new Pipe("keyvalue");
        pipe = new Each(pipe, new Fields(new Comparable[]{"offset"}), (Function)new ExpressionFunction(Fields.ARGS, "new org.apache.hadoop.io.LongWritable($0)", Long.TYPE), Fields.REPLACE);
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new ExpressionFunction(Fields.ARGS, "new org.apache.hadoop.io.Text($0)", String.class), Fields.REPLACE);
        Hfs tapKeyValue = new Hfs((Scheme)new WritableSequenceFile(new Fields(new Comparable[]{"offset", "line"}), LongWritable.class, Text.class), this.getOutputPath("keyvalue"), SinkMode.REPLACE);
        Hfs tapKey = new Hfs((Scheme)new WritableSequenceFile(new Fields(new Comparable[]{"offset"}), LongWritable.class, null), this.getOutputPath("key"), SinkMode.REPLACE);
        Hfs tapValue = new Hfs((Scheme)new WritableSequenceFile(new Fields(new Comparable[]{"line"}), Text.class), this.getOutputPath("value"), SinkMode.REPLACE);
        Flow flowKeyValue = this.getPlatform().getFlowConnector(this.getProperties()).connect((Tap)source, (Tap)tapKeyValue, pipe);
        Flow flowKey = this.getPlatform().getFlowConnector(this.getProperties()).connect((Tap)tapKeyValue, (Tap)tapKey, new Pipe("key"));
        Flow flowValue = this.getPlatform().getFlowConnector(this.getProperties()).connect((Tap)tapKeyValue, (Tap)tapValue, new Pipe("value"));
        Cascade cascade = new CascadeConnector(this.getProperties()).connect("keyvalues", new Flow[]{flowKeyValue, flowKey, flowValue});
        cascade.complete();
        WritableSequenceFilePlatformTest.validateLength((Flow)flowKeyValue, (int)10, (int)2);
        WritableSequenceFilePlatformTest.validateLength((Flow)flowKey, (int)10, (int)1);
        WritableSequenceFilePlatformTest.validateLength((Flow)flowValue, (int)10, (int)1);
    }
}

