/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole.threshold;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import net.welen.jmole.Configuration;
import net.welen.jmole.JMole;
import net.welen.jmole.collector.MBeanCollector;
import net.welen.jmole.presentation.PresentationInformation;
import net.welen.jmole.threshold.JMoleNotification;
import net.welen.jmole.threshold.NotificationUserData;
import net.welen.jmole.threshold.Threshold;
import net.welen.jmole.threshold.ThresholdValues;

public class ThresholdThread
extends Thread {
    private static final Logger LOG = Logger.getLogger(ThresholdThread.class.getName());
    private static final Object sequenceNumberLock = new Object();
    private static long sequenceNumber = 0L;
    private boolean stopped = false;
    private long interval = 60000L;
    private JMole jmole;
    private Map<ObjectName, String> warningMessages = new HashMap<ObjectName, String>();
    private Map<ObjectName, String> criticalMessages = new HashMap<ObjectName, String>();
    private Map<ObjectName, Configuration> configurations = new HashMap<ObjectName, Configuration>();

    public ThresholdThread(String name, long interval, JMole jmole) {
        super(name);
        this.interval = interval;
        this.jmole = jmole;
    }

    @Override
    public void run() {
        this.stopped = false;
        while (!this.stopped) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                LOG.log(Level.FINE, e.getMessage(), e);
            }
            LOG.log(Level.FINE, "Running threshold check");
            HashMap<ObjectName, String> newWarningMessages = new HashMap<ObjectName, String>();
            HashMap<ObjectName, String> newCriticalMessages = new HashMap<ObjectName, String>();
            for (Configuration configuration : this.jmole.getConfiguration()) {
                for (Map.Entry<String, Threshold> entry : configuration.getThresholds().entrySet()) {
                    String attribute = entry.getKey();
                    Threshold threshold = entry.getValue();
                    if (threshold.getInterval() != this.interval) continue;
                    try {
                        for (ObjectName objectName : configuration.getMBeanFinder().getMatchingObjectNames()) {
                            this.configurations.put(objectName, configuration);
                            try {
                                String messageText;
                                String high;
                                String low;
                                Boolean b;
                                if (this.stopped) {
                                    return;
                                }
                                MBeanCollector mBeanCollector = configuration.getMBeanCollector();
                                Object valueObject = mBeanCollector.getValues(objectName).get(attribute);
                                if (valueObject == null) {
                                    LOG.log(Level.FINE, "Data collection returned null. Skipping it as it is probably not calculated yet");
                                    continue;
                                }
                                Double value = null;
                                value = valueObject instanceof Boolean ? ((b = (Boolean)valueObject).booleanValue() ? Double.valueOf(1.0) : Double.valueOf(0.0)) : Double.valueOf(Double.parseDouble(valueObject.toString()));
                                ThresholdValues individualThresholdValue = threshold.getIndividualThresholds().get(attribute);
                                String message = threshold.getMessage();
                                if (individualThresholdValue == null) {
                                    low = threshold.getWarningLowThreshold();
                                    high = threshold.getWarningHighThreshold();
                                } else {
                                    low = individualThresholdValue.getWarningLowThreshold();
                                    high = individualThresholdValue.getWarningHighThreshold();
                                    if (individualThresholdValue.getMessage() != null) {
                                        message = individualThresholdValue.getMessage();
                                    }
                                }
                                low = Threshold.calculateThreshold(low, mBeanCollector, objectName, attribute);
                                high = Threshold.calculateThreshold(high, mBeanCollector, objectName, attribute);
                                PresentationInformation presentationInformation = configuration.getPresentationInformation();
                                String name = configuration.getMBeanCollector().getConstructedName(objectName);
                                String label = presentationInformation.translateAttributeLabel(attribute);
                                if (!low.isEmpty() && value < Double.parseDouble(low)) {
                                    messageText = this.constructMessage(message, label + ": " + value + " < " + low);
                                    LOG.log(Level.FINE, "Threshold trigged: " + messageText);
                                    this.sendJMXNotification(false, attribute, name, presentationInformation, messageText);
                                    newWarningMessages.put(objectName, messageText);
                                }
                                if (!high.isEmpty() && value > Double.parseDouble(high)) {
                                    messageText = this.constructMessage(message, label + ": " + value + " > " + high);
                                    LOG.log(Level.FINE, "Threshold trigged: " + messageText);
                                    this.sendJMXNotification(false, attribute, name, presentationInformation, messageText);
                                    newWarningMessages.put(objectName, messageText);
                                }
                                message = threshold.getMessage();
                                if (individualThresholdValue == null) {
                                    low = threshold.getCriticalLowThreshold();
                                    high = threshold.getCriticalHighThreshold();
                                } else {
                                    low = individualThresholdValue.getCriticalLowThreshold();
                                    high = individualThresholdValue.getCriticalHighThreshold();
                                    if (individualThresholdValue.getMessage() != null) {
                                        message = individualThresholdValue.getMessage();
                                    }
                                }
                                low = Threshold.calculateThreshold(low, mBeanCollector, objectName, attribute);
                                high = Threshold.calculateThreshold(high, mBeanCollector, objectName, attribute);
                                if (!low.isEmpty() && value < Double.parseDouble(low)) {
                                    messageText = this.constructMessage(message, label + ": " + value + " < " + low);
                                    LOG.log(Level.FINE, "Threshold trigged: " + messageText);
                                    this.sendJMXNotification(true, attribute, name, presentationInformation, messageText);
                                    newCriticalMessages.put(objectName, messageText);
                                }
                                if (high.isEmpty() || !(value > Double.parseDouble(high))) continue;
                                messageText = this.constructMessage(message, label + ": " + value + " > " + high);
                                LOG.log(Level.FINE, "Threshold trigged: " + messageText);
                                this.sendJMXNotification(true, attribute, name, presentationInformation, messageText);
                                newCriticalMessages.put(objectName, messageText);
                            }
                            catch (Throwable t) {
                                LOG.log(Level.SEVERE, t.getMessage(), t);
                            }
                        }
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, e.getMessage(), e);
                    }
                    this.warningMessages = newWarningMessages;
                    this.criticalMessages = newCriticalMessages;
                }
            }
        }
        LOG.log(Level.FINE, "Thread stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendJMXNotification(boolean critical, String attribute, String name, PresentationInformation presentationInformation, String message) {
        String type = JMoleNotification.TYPE_WARNING;
        if (critical) {
            type = JMoleNotification.TYPE_CRITICAL;
        }
        Object object = sequenceNumberLock;
        synchronized (object) {
            try {
                JMoleNotification n = new JMoleNotification(type, new ObjectName("net.welen.jmole:service=jmole"), sequenceNumber++, message);
                n.setUserData(new NotificationUserData(name, attribute, presentationInformation));
                LOG.log(Level.FINE, "Sending notification: " + n);
                this.jmole.sendNotification((Notification)n);
            }
            catch (MalformedObjectNameException e) {
                LOG.log(Level.SEVERE, "Couldn't send JMX notification: " + e.getMessage(), e);
            }
        }
    }

    private String constructMessage(String message, String problemText) {
        return String.format(message, problemText);
    }

    public Configuration getConfiguration(ObjectName objectName) {
        return this.configurations.get(objectName);
    }

    public void stopThread() {
        LOG.log(Level.FINE, "Stopping thread");
        this.stopped = true;
    }

    public Map<ObjectName, String> getWarningMessages() {
        return this.warningMessages;
    }

    public Map<ObjectName, String> getCriticalMessages() {
        return this.criticalMessages;
    }
}

