/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole.protocols.nrpe;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.welen.jmole.JMole;
import net.welen.jmole.presentation.PresentationInformation;
import net.welen.jmole.protocols.AbstractProtocol;
import net.welen.jmole.protocols.nrpe.NRPEMBean;
import net.welen.jmole.protocols.nrpe.NRPESocketHandler;

public class NRPE
extends AbstractProtocol
implements NRPEMBean,
Runnable {
    private static final Logger LOG = Logger.getLogger(NRPE.class.getName());
    private static String PROPERTY_NRPE_ADDRESS = "jmole.protocol.nrpe.address";
    private static String PROPERTY_NRPE_PORT = "jmole.protocol.nrpe.port";
    private static String PROPERTY_NRPE_ACCEPTED_HOSTS = "jmole.protocol.nrpe.acceptedHosts";
    private static String PROPERTY_NRPE_TCP_READ_TIMOUT = "jmole.protocol.nrpe.tcpReadTimeOut";
    private static String PROPERTY_NRPE_MAX_MESSAGE_SIZE = "jmole.protocol.nrpe.maxMessageSize";
    private static String PROPERTY_NRPE_USE_SSL = "jmole.protocol.nrpe.useSSL";
    private ServerSocket serverSocket;
    private String address;
    private Integer port;
    private String[] acceptedHosts = new String[]{"127.0.0.1"};
    private Integer tcpReadTimeOut;
    private boolean stopped = false;
    private boolean socketStopped = true;
    private Integer maxMessageSize = 1024;

    @Override
    public void startProtocol(JMole jmole) throws Exception {
        String acceptedHostsString;
        this.address = System.getProperty(PROPERTY_NRPE_ADDRESS);
        if (this.address == null) {
            this.address = "localhost";
        }
        this.port = Integer.getInteger(PROPERTY_NRPE_PORT);
        if (this.port == null) {
            this.port = 5666;
        }
        if ((acceptedHostsString = System.getProperty(PROPERTY_NRPE_ACCEPTED_HOSTS)) != null) {
            this.acceptedHosts = acceptedHostsString.split(",");
        }
        this.tcpReadTimeOut = Integer.getInteger(PROPERTY_NRPE_TCP_READ_TIMOUT);
        if (this.tcpReadTimeOut == null) {
            this.tcpReadTimeOut = 10000;
        }
        this.maxMessageSize = Integer.getInteger(PROPERTY_NRPE_MAX_MESSAGE_SIZE);
        if (this.maxMessageSize == null) {
            this.maxMessageSize = 1024;
        }
        LOG.log(Level.INFO, "JMole NRPE protocol starting; " + this.address + ":" + this.port);
        this.serverSocket = new ServerSocket(this.port, -1, InetAddress.getByName(this.address));
        this.serverSocket.setSoTimeout(1000);
        new Thread(this).start();
        super.startProtocol(jmole);
    }

    @Override
    public void stopProtocol() throws Exception {
        this.stopped = true;
        while (!this.socketStopped) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        super.stopProtocol();
        LOG.log(Level.INFO, "JMole NRPE protocol stopped");
    }

    @Override
    public void run() {
        this.stopped = false;
        this.socketStopped = false;
        try {
            while (!this.stopped) {
                try {
                    Socket socket = this.serverSocket.accept();
                    new NRPESocketHandler(socket, this).start();
                }
                catch (SocketTimeoutException e) {
                    LOG.log(Level.FINEST, "SocketTimeoutException", e);
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Munin socket IOException", e);
                }
            }
        }
        finally {
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            this.socketStopped = true;
        }
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public void setPort(Integer port) {
        this.port = port;
    }

    @Override
    public Integer getTcpReadTimeOut() {
        return this.tcpReadTimeOut;
    }

    @Override
    public void setTcpReadTimeOut(Integer timeout) {
        this.tcpReadTimeOut = timeout;
    }

    @Override
    public Integer getMaxMessageSize() {
        return this.maxMessageSize;
    }

    @Override
    public void handleWarning(String name, String attribute, PresentationInformation presentationInformation, String message) throws Exception {
    }

    @Override
    public void handleCritical(String name, String attribute, PresentationInformation presentationInformation, String message) throws Exception {
    }
}

