/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole.protocols.logger;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Date;
import java.util.logging.Level;
import net.welen.jmole.JMole;
import net.welen.jmole.presentation.PresentationInformation;
import net.welen.jmole.protocols.AbstractIntervalProtocol;
import net.welen.jmole.protocols.ProtocolMessagePlaceholder;
import net.welen.jmole.protocols.Utils;
import net.welen.jmole.protocols.logger.LoggerMBean;

public class Logger
extends AbstractIntervalProtocol
implements LoggerMBean {
    private static final java.util.logging.Logger LOG = java.util.logging.Logger.getLogger(Logger.class.getName());
    private static final char SEP = '/';
    private static String PROPERTY_LOGGER_NAME = "jmole.protocol.logger.name";
    private static String PROPERTY_LOGGER_FORMAT = "jmole.protocol.logger.format";
    private static String PROPERTY_LOGGER_LEVEL = "jmole.protocol.logger.level";
    private static String PROPERTY_LOGGER_INTERVAL = "jmole.protocol.logger.interval";
    private Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();
    private Level level;
    private String format;
    private java.util.logging.Logger protocolLogger = java.util.logging.Logger.getLogger("JMole");

    @Override
    public void startProtocol(JMole jmole) throws Exception {
        Long interval;
        super.startProtocol(jmole);
        String levelString = System.getProperty(PROPERTY_LOGGER_LEVEL);
        if (levelString == null) {
            levelString = "INFO";
        }
        this.level = Level.parse(levelString);
        String name = System.getProperty(PROPERTY_LOGGER_NAME);
        if (name != null) {
            this.protocolLogger = java.util.logging.Logger.getLogger(name);
        }
        this.format = System.getProperty(PROPERTY_LOGGER_FORMAT);
        if (this.format == null) {
            this.format = "[%k] %a [%A] = %v %U";
        }
        if ((interval = Long.getLong(PROPERTY_LOGGER_INTERVAL)) != null) {
            this.setInterval(interval);
        }
        LOG.log(Level.INFO, "JMole Logger protocol started: Level=" + levelString + ", Interval=" + interval);
    }

    @Override
    public void stopProtocol() throws Exception {
        LOG.log(Level.INFO, "Stopping JMole Logger protocol");
        super.stopProtocol();
        LOG.log(Level.INFO, "JMole Logger protocol stopped");
    }

    @Override
    public String getLevel() {
        return this.level.getName();
    }

    @Override
    public void setLevel(String level) {
        this.level = Level.parse(level);
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected void handleMeasurement(String category, String name, String attribute, Object value, PresentationInformation presentationInformation) throws Exception {
        if (this.getFormat().toUpperCase().equals("JSON")) {
            this.protocolLogger.log(this.level, this.gson.toJson((Object)new ProtocolMessagePlaceholder("metric", new Date(), null, category, name, attribute, value, presentationInformation)));
        } else {
            this.protocolLogger.log(this.level, Utils.formatLogString(this.format, '/', category, name, attribute, value, presentationInformation));
        }
    }

    @Override
    public void handleWarning(String name, String attribute, PresentationInformation presentationInformation, String message) throws Exception {
        if (this.getFormat().toUpperCase().equals("JSON")) {
            this.protocolLogger.log(Level.WARNING, this.gson.toJson((Object)new ProtocolMessagePlaceholder("warning", new Date(), message, presentationInformation.getCategory(), name, attribute, null, presentationInformation)));
        } else {
            this.protocolLogger.log(Level.WARNING, Utils.formatLogString(this.format, '/', presentationInformation.getCategory(), name, attribute, message, presentationInformation));
        }
    }

    @Override
    public void handleCritical(String name, String attribute, PresentationInformation presentationInformation, String message) throws Exception {
        if (this.getFormat().toUpperCase().equals("JSON")) {
            this.protocolLogger.log(Level.SEVERE, this.gson.toJson((Object)new ProtocolMessagePlaceholder("critical", new Date(), message, presentationInformation.getCategory(), name, attribute, null, presentationInformation)));
        } else {
            this.protocolLogger.log(Level.SEVERE, Utils.formatLogString(this.format, '/', presentationInformation.getCategory(), name, attribute, message, presentationInformation));
        }
    }
}

