/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole.protocols;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectName;
import net.welen.jmole.JMole;
import net.welen.jmole.Utils;
import net.welen.jmole.protocols.Protocol;
import net.welen.jmole.protocols.ProtocolMBean;
import net.welen.jmole.threshold.JMoleNotification;
import net.welen.jmole.threshold.NotificationUserData;

public abstract class AbstractProtocol
implements Protocol,
ProtocolMBean {
    private static final Logger LOG = Logger.getLogger(AbstractProtocol.class.getName());
    private String name;
    private JMole jmole;
    private MBeanServer server = Utils.getMBeanServer();

    @Override
    public void startProtocol(JMole jmole) throws Exception {
        this.jmole = jmole;
        this.server.addNotificationListener(new ObjectName("net.welen.jmole:service=jmole"), this, null, null);
    }

    @Override
    public void stopProtocol() throws Exception {
        this.server.removeNotificationListener(new ObjectName("net.welen.jmole:service=jmole"), this);
    }

    @Override
    public JMole getJMole() {
        return this.jmole;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        block6: {
            if (notification instanceof JMoleNotification) {
                LOG.log(Level.FINE, "Notification recieved");
                JMoleNotification aJMoleNotification = (JMoleNotification)notification;
                NotificationUserData notificationUserData = (NotificationUserData)aJMoleNotification.getUserData();
                String name = notificationUserData.getName();
                String attribute = notificationUserData.getAttribute();
                String type = aJMoleNotification.getType();
                try {
                    if (type.equals(JMoleNotification.TYPE_WARNING)) {
                        this.handleWarning(name, attribute, notificationUserData.getPresentationInformation(), aJMoleNotification.getMessage());
                        break block6;
                    }
                    if (type.equals(JMoleNotification.TYPE_CRITICAL)) {
                        this.handleCritical(name, attribute, notificationUserData.getPresentationInformation(), aJMoleNotification.getMessage());
                        break block6;
                    }
                    LOG.log(Level.SEVERE, "Unknown type in notification: " + type);
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Failed in handlin notification", e);
                }
            } else {
                LOG.log(Level.SEVERE, "Unknown notification recieved: " + notification);
            }
        }
    }
}

