/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole.protocols;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import net.welen.jmole.JMole;
import net.welen.jmole.presentation.PresentationInformation;
import net.welen.jmole.protocols.AbstractProtocol;
import net.welen.jmole.protocols.IntervalProtocolMBean;

public abstract class AbstractIntervalProtocol
extends AbstractProtocol
implements IntervalProtocolMBean,
Runnable {
    private static final Logger LOG = Logger.getLogger(AbstractIntervalProtocol.class.getName());
    private static final char SEP = '/';
    static final long DEFAULT_INTERVAL = 60000L;
    private Thread collector;
    private boolean stopRequested = false;
    private boolean threadStopped = false;
    private long interval = 60000L;

    @Override
    public void startProtocol(JMole jmole) throws Exception {
        super.startProtocol(jmole);
        this.collector = new Thread(this);
        this.collector.setName("JMole protocol thread: " + this.getName());
        this.collector.start();
        LOG.log(Level.FINE, "JMole protocol thread started: Interval=" + this.getInterval());
    }

    @Override
    public void stopProtocol() throws Exception {
        LOG.log(Level.FINE, "Stopping protocol thread");
        this.stopRequested = true;
        this.collector.interrupt();
        while (!this.threadStopped) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOG.log(Level.FINE, e.getMessage(), e);
            }
        }
        super.stopProtocol();
        LOG.log(Level.FINE, "Protocol thread stopped");
    }

    @Override
    public void run() {
        this.stopRequested = false;
        this.threadStopped = false;
        try {
            while (!this.stopRequested) {
                try {
                    Thread.sleep(this.getInterval());
                }
                catch (InterruptedException e) {
                    LOG.log(Level.FINE, e.getMessage(), e);
                }
                if (this.stopRequested) {
                    return;
                }
                try {
                    this.handleMeasurements();
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        finally {
            this.threadStopped = true;
        }
    }

    private void handleMeasurements() throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IntrospectionException {
        HashMap<Object, PresentationInformation> presentationInformationMap = new HashMap<Object, PresentationInformation>();
        for (Map.Entry<String, List<Map<String, Map<String, Object>>>> categoryEntry : this.getJMole().collectMeasurements(presentationInformationMap).entrySet()) {
            Iterator<Map<String, Map<String, Object>>> iter = categoryEntry.getValue().iterator();
            while (iter.hasNext()) {
                for (Map.Entry<String, Map<String, Object>> nameEntry : iter.next().entrySet()) {
                    for (Map.Entry<String, Object> attributeEntry : nameEntry.getValue().entrySet()) {
                        String piKey = categoryEntry.getKey() + nameEntry.getKey();
                        PresentationInformation presentationInformation = (PresentationInformation)presentationInformationMap.get(piKey);
                        if (presentationInformation == null) {
                            LOG.severe("No presentation information found for: " + piKey + ", Skipping it");
                            continue;
                        }
                        try {
                            if (attributeEntry.getValue() == null) continue;
                            this.handleMeasurement(categoryEntry.getKey(), nameEntry.getKey(), attributeEntry.getKey(), attributeEntry.getValue(), presentationInformation);
                        }
                        catch (Exception e) {
                            LOG.log(Level.SEVERE, e.getMessage() + ": " + categoryEntry.getKey() + '/' + nameEntry.getKey() + '/' + attributeEntry.getKey(), e);
                        }
                    }
                }
            }
        }
    }

    @Override
    public long getInterval() {
        return this.interval;
    }

    @Override
    public void setInterval(long interval) {
        this.interval = interval;
    }

    protected abstract void handleMeasurement(String var1, String var2, String var3, Object var4, PresentationInformation var5) throws Exception;
}

