/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole;

import java.lang.management.ManagementFactory;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

public class Utils {
    private static final Logger LOG = Logger.getLogger(Utils.class.getName());
    protected static final String PROPERTY_MBEAN_SERVER = "jmole.mbeanserver.agentid";

    public static MBeanServer getMBeanServer() {
        String agentId = System.getProperty(PROPERTY_MBEAN_SERVER);
        if (agentId == null) {
            return ManagementFactory.getPlatformMBeanServer();
        }
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        for (MBeanServer server : servers) {
            try {
                if (!server.getAttribute(new ObjectName("JMImplementation:type=MBeanServerDelegate"), "MBeanServerId").toString().matches(agentId)) continue;
                return server;
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Can't get the AgentId", e);
            }
        }
        ArrayList<String> agentIds = new ArrayList<String>();
        for (MBeanServer server : servers) {
            try {
                agentIds.add(server.getAttribute(new ObjectName("JMImplementation:type=MBeanServerDelegate"), "MBeanServerId").toString());
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Can't get the AgentId", e);
            }
        }
        throw new IllegalArgumentException("MBean server with id: " + agentId + " not found. Available id: " + agentIds);
    }

    public static String rpnCalculate(String expr) {
        if (expr == null || expr.isEmpty()) {
            return "";
        }
        Stack<Double> stack = new Stack<Double>();
        String[] pieces = expr.split(",");
        for (int i = 0; i < pieces.length; ++i) {
            Double lastLastValue;
            Double lastValue;
            String value = pieces[i].trim();
            if (value.equals("+")) {
                lastValue = (Double)stack.pop();
                lastLastValue = (Double)stack.pop();
                stack.push(lastLastValue + lastValue);
                continue;
            }
            if (value.equals("-")) {
                lastValue = (Double)stack.pop();
                lastLastValue = (Double)stack.pop();
                stack.push(lastLastValue - lastValue);
                continue;
            }
            if (value.equals("*")) {
                lastValue = (Double)stack.pop();
                lastLastValue = (Double)stack.pop();
                stack.push(lastLastValue * lastValue);
                continue;
            }
            if (value.equals("/")) {
                lastValue = (Double)stack.pop();
                lastLastValue = (Double)stack.pop();
                stack.push(lastLastValue / lastValue);
                continue;
            }
            stack.push(Double.valueOf(pieces[i]));
        }
        double answer = (Double)stack.pop();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat formatter = new DecimalFormat("#.#", symbols);
        return formatter.format(answer);
    }
}

