/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.welen.jmole.Configuration;
import net.welen.jmole.JMoleMBean;
import net.welen.jmole.Utils;
import net.welen.jmole.presentation.PresentationInformation;
import net.welen.jmole.threshold.Threshold;
import net.welen.jmole.threshold.ThresholdThread;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JMole
extends NotificationBroadcasterSupport
implements JMoleMBean {
    private static final Logger LOG = Logger.getLogger(JMole.class.getName());
    public static final String OBJECT_NAME = "net.welen.jmole:service=jmole";
    public static final String CONFIG_FILENAMES_PROPERTY = "jmole.config.filenames";
    public static final String CONFIG_FILENAME_PROPERTY_PREFIX = "jmole.config.filename.";
    public static final String CONFIG_FILENAME_XSLT_PROPERTY_PREFIX = "jmole.config.xslt.";
    public static final String CONFIG_LEVEL_PROPERTY = "jmole.config.level";
    public static final String NOTIFICATION_TYPE = "jmole.reconfigured";
    private MBeanServer server = Utils.getMBeanServer();
    private List<Configuration> configurations = new ArrayList<Configuration>();
    private Map<Long, ThresholdThread> thresholdThreads = new HashMap<Long, ThresholdThread>();
    private Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();

    public void register() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException, InstanceNotFoundException {
        LOG.log(Level.FINE, "Registering JMole MBean");
        this.server.registerMBean(this, new ObjectName(OBJECT_NAME));
    }

    public void unregister() throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        LOG.log(Level.FINE, "Removing JMole MBean");
        this.deactivateThresholds();
        this.server.unregisterMBean(new ObjectName(OBJECT_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void configure() throws MalformedObjectNameException, FileNotFoundException, MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IntrospectionException {
        List<Configuration> newConfigurations = Collections.synchronizedList(new ArrayList());
        String fileNames = this.getConfigFileNames();
        for (String fileName : fileNames.split("\\|")) {
            InputStream configStream;
            XMLDecoder decoder;
            block56: {
                byte[] data;
                SimpleExceptionListener myListener;
                block55: {
                    block53: {
                        block54: {
                            LOG.log(Level.INFO, "Configuring JMole with config file: " + fileName);
                            decoder = null;
                            configStream = null;
                            myListener = new SimpleExceptionListener();
                            data = null;
                            configStream = new File(fileName).exists() ? new BufferedInputStream(new FileInputStream(fileName)) : Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
                            if (configStream != null) break block53;
                            LOG.log(Level.SEVERE, String.format("Unable to load config from '%s'", fileName));
                            Exception exception2 = myListener.getException();
                            if (exception2 == null) break block54;
                            LOG.log(Level.SEVERE, String.format("Config file is corrupt '%s'%n== CONFIG START ==%n%s%n== CONFIG STOP ==", fileName, new String(data)), exception2);
                        }
                        if (decoder != null) {
                            decoder.close();
                        }
                        if (configStream == null) continue;
                        try {
                            configStream.close();
                        }
                        catch (IOException e) {
                            LOG.log(Level.WARNING, "Couldn't close configStream", e);
                        }
                        continue;
                    }
                    try {
                        data = this.readData(configStream);
                    }
                    catch (IOException e) {
                        LOG.log(Level.SEVERE, String.format("Unable to load config from '%s'", fileName), e);
                        Exception exception3 = myListener.getException();
                        if (exception3 != null) {
                            LOG.log(Level.SEVERE, String.format("Config file is corrupt '%s'%n== CONFIG START ==%n%s%n== CONFIG STOP ==", fileName, new String(data)), exception3);
                        }
                        if (decoder != null) {
                            decoder.close();
                        }
                        if (configStream == null) continue;
                        try {
                            configStream.close();
                        }
                        catch (IOException iOException) {
                            LOG.log(Level.WARNING, "Couldn't close configStream", iOException);
                        }
                        continue;
                    }
                    try {
                        data = this.replaceAllSystemProperties(data);
                        String xslt = null;
                        for (Map.Entry entry : System.getProperties().entrySet()) {
                            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                            String key = (String)entry.getKey();
                            String value = (String)entry.getValue();
                            if (!key.startsWith(CONFIG_FILENAME_PROPERTY_PREFIX) || !value.equals(fileName)) continue;
                            String part = key.substring(CONFIG_FILENAME_PROPERTY_PREFIX.length());
                            xslt = System.getProperty(CONFIG_FILENAME_XSLT_PROPERTY_PREFIX + part);
                        }
                        if (xslt == null) break block55;
                        try {
                            LOG.log(Level.INFO, String.format("Applying XSLT: '%s' on config file: '%s'", xslt, fileName));
                            data = this.transformData(data, xslt);
                        }
                        catch (Exception e) {
                            LOG.log(Level.SEVERE, String.format("Unable to apply specified XSLT transformation to config file '%s'", fileName), e);
                            Exception exception = myListener.getException();
                            if (exception != null) {
                                LOG.log(Level.SEVERE, String.format("Config file is corrupt '%s'%n== CONFIG START ==%n%s%n== CONFIG STOP ==", fileName, new String(data)), exception);
                            }
                            if (decoder != null) {
                                decoder.close();
                            }
                            if (configStream == null) continue;
                            try {
                                configStream.close();
                            }
                            catch (IOException e3) {
                                LOG.log(Level.WARNING, "Couldn't close configStream", e3);
                            }
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        Exception exception4 = myListener.getException();
                        if (exception4 != null) {
                            LOG.log(Level.SEVERE, String.format("Config file is corrupt '%s'%n== CONFIG START ==%n%s%n== CONFIG STOP ==", fileName, new String(data)), exception4);
                        }
                        if (decoder != null) {
                            decoder.close();
                        }
                        if (configStream != null) {
                            try {
                                configStream.close();
                            }
                            catch (IOException e) {
                                LOG.log(Level.WARNING, "Couldn't close configStream", e);
                            }
                        }
                        throw throwable;
                    }
                }
                try {
                    this.validateData(data);
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, String.format("Unable to validate config file '%s'", fileName), e);
                    Exception exception = myListener.getException();
                    if (exception != null) {
                        LOG.log(Level.SEVERE, String.format("Config file is corrupt '%s'%n== CONFIG START ==%n%s%n== CONFIG STOP ==", fileName, new String(data)), exception);
                    }
                    if (decoder != null) {
                        decoder.close();
                    }
                    if (configStream == null) continue;
                    try {
                        configStream.close();
                    }
                    catch (IOException e4) {
                        LOG.log(Level.WARNING, "Couldn't close configStream", e4);
                    }
                    continue;
                }
                try {
                    data = this.transformData(data, "META-INF/JMole.xsl");
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, String.format("Unable to transform config file '%s'", fileName), e);
                    Exception exception = myListener.getException();
                    if (exception != null) {
                        LOG.log(Level.SEVERE, String.format("Config file is corrupt '%s'%n== CONFIG START ==%n%s%n== CONFIG STOP ==", fileName, new String(data)), exception);
                    }
                    if (decoder != null) {
                        decoder.close();
                    }
                    if (configStream == null) continue;
                    try {
                        configStream.close();
                    }
                    catch (IOException e5) {
                        LOG.log(Level.WARNING, "Couldn't close configStream", e5);
                    }
                    continue;
                }
                decoder = new XMLDecoder(new ByteArrayInputStream(data), null, (ExceptionListener)myListener, this.getClass().getClassLoader());
                Object newDecodedConfigurations = null;
                try {
                    newDecodedConfigurations = decoder.readObject();
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    LOG.log(Level.SEVERE, String.format("Config file is corrupt '%s'%n== CONFIG START ==%n%s%n== CONFIG STOP ==", fileName, new String(data)), arrayIndexOutOfBoundsException);
                    Exception exception5 = myListener.getException();
                    if (exception5 != null) {
                        LOG.log(Level.SEVERE, String.format("Config file is corrupt '%s'%n== CONFIG START ==%n%s%n== CONFIG STOP ==", fileName, new String(data)), exception5);
                    }
                    if (decoder != null) {
                        decoder.close();
                    }
                    if (configStream == null) continue;
                    try {
                        configStream.close();
                    }
                    catch (IOException e6) {
                        LOG.log(Level.WARNING, "Couldn't close configStream", e6);
                    }
                    continue;
                }
                newConfigurations.addAll((List)newDecodedConfigurations);
                Exception exception = myListener.getException();
                if (exception == null) break block56;
                LOG.log(Level.SEVERE, String.format("Config file is corrupt '%s'%n== CONFIG START ==%n%s%n== CONFIG STOP ==", fileName, new String(data)), exception);
            }
            if (decoder != null) {
                decoder.close();
            }
            if (configStream == null) continue;
            try {
                configStream.close();
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Couldn't close configStream", e);
            }
        }
        int level = this.getLevel();
        if (level < 1 || level > 5) {
            throw new RuntimeException("jmole.config.level must be 1-5");
        }
        ArrayList<Configuration> levelFilteredConfigurations = new ArrayList<Configuration>();
        for (Configuration configuration : newConfigurations) {
            if (configuration.getLevel() > level) continue;
            levelFilteredConfigurations.add(configuration);
        }
        this.configurations = levelFilteredConfigurations;
        this.deactivateThresholds();
        this.activateThresholds();
    }

    @Override
    public String getConfigFileNames() {
        String fileNames = "JMole_JVM.xml";
        if (System.getProperty(CONFIG_FILENAMES_PROPERTY) != null) {
            LOG.log(Level.WARNING, "JMole config property jmole.config.filenames is deprecated. Use jmole.config.filename.* instead");
            fileNames = System.getProperty(CONFIG_FILENAMES_PROPERTY);
        } else {
            StringBuilder configs = new StringBuilder();
            for (Object prop : System.getProperties().keySet()) {
                String propString;
                if (!(prop instanceof String) || !(propString = (String)prop).startsWith(CONFIG_FILENAME_PROPERTY_PREFIX)) continue;
                if (configs.length() > 0) {
                    configs.append("|");
                }
                configs.append(System.getProperty(propString));
            }
            if (configs.length() > 0) {
                fileNames = configs.toString();
            } else {
                LOG.log(Level.INFO, "No config file(s) configured. Using: JMole_JVM.xml");
            }
        }
        return fileNames;
    }

    private byte[] replaceAllSystemProperties(byte[] data) {
        String stringData = new String(data);
        Properties clone = new Properties();
        clone.putAll((Map<?, ?>)System.getProperties());
        for (Map.Entry<Object, Object> propEntry : clone.entrySet()) {
            String key = (String)propEntry.getKey();
            String value = (String)propEntry.getValue();
            stringData = stringData.replaceAll("\\$\\{" + key + ":.*\\}", value);
            stringData = stringData.replaceAll("\\$\\{" + key + "\\}", value);
        }
        stringData = stringData.replaceAll("\\$\\{.*:|\\}", "");
        return stringData.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readData(InputStream inputStream) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = inputStream.read(buffer)) != -1) {
                data.write(buffer, 0, read);
            }
        }
        finally {
            try {
                data.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return data.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateData(byte[] data) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            schema = factory.newSchema(new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/JMole.xsd")));
        }
        catch (SAXParseException e) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                schema = factory.newSchema(new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/JMole.xsd")));
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
        Validator validator = schema.newValidator();
        validator.validate(new StreamSource(new ByteArrayInputStream(data)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] transformData(byte[] data, String xsltFile) throws TransformerException {
        ByteArrayOutputStream answer = new ByteArrayOutputStream();
        StreamResult outputStream = new StreamResult(answer);
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setErrorListener(new ErrorListener(){

            @Override
            public void warning(TransformerException exception) throws TransformerException {
                LOG.log(Level.FINE, exception.getMessage(), exception);
            }

            @Override
            public void fatalError(TransformerException exception) throws TransformerException {
                LOG.log(Level.FINE, exception.getMessage(), exception);
            }

            @Override
            public void error(TransformerException exception) throws TransformerException {
                LOG.log(Level.FINE, exception.getMessage(), exception);
            }
        });
        if (new File(xsltFile).exists()) {
            try {
                StreamSource xslt = new StreamSource(new BufferedInputStream(new FileInputStream(xsltFile)));
                Transformer transformer = factory.newTransformer(xslt);
                transformer.transform(new StreamSource(new ByteArrayInputStream(data)), outputStream);
            }
            catch (FileNotFoundException e) {
                LOG.log(Level.SEVERE, "XSLT file: " + xsltFile + " not found.", e);
                throw new TransformerException(e.getMessage(), e);
            }
        }
        try {
            LOG.log(Level.FINE, "Getting the XSLT file from Thread.currentThread().getContextClassLoader()");
            StreamSource xslt = new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream(xsltFile));
            Transformer transformer = factory.newTransformer(xslt);
            transformer.transform(new StreamSource(new ByteArrayInputStream(data)), outputStream);
        }
        catch (Exception e) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                LOG.log(Level.FINE, "Getting the XSLT file from getClass().getClassLoader()");
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                StreamSource xslt = new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream(xsltFile));
                Transformer transformer = factory.newTransformer(xslt);
                transformer.transform(new StreamSource(new ByteArrayInputStream(data)), outputStream);
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
        return answer.toByteArray();
    }

    public List<Configuration> getConfiguration() {
        return this.configurations;
    }

    @Override
    public Map<String, List<Map<String, Map<String, Object>>>> collectMeasurements() throws InstanceNotFoundException, ReflectionException, MBeanException, AttributeNotFoundException, IntrospectionException {
        return this.collectMeasurements((Map<Object, PresentationInformation>)null);
    }

    public Map<String, List<Map<String, Map<String, Object>>>> collectMeasurements(Map<Object, PresentationInformation> presentationInformation) throws InstanceNotFoundException, ReflectionException, MBeanException, AttributeNotFoundException, IntrospectionException {
        HashMap<String, List<Map<String, Map<String, Object>>>> answer = new HashMap<String, List<Map<String, Map<String, Object>>>>();
        for (Configuration configuration : this.configurations) {
            Map<String, Map<String, Object>> data;
            String category = configuration.getPresentationInformation().getCategory();
            if (answer.containsKey(category) || (data = this.collectMeasurements(category, presentationInformation)).isEmpty()) continue;
            if (answer.get(category) == null) {
                answer.put(category, new ArrayList());
            }
            ((List)answer.get(category)).add(data);
        }
        return answer;
    }

    @Override
    public String collectMeasurementsAsJSON() throws InstanceNotFoundException, ReflectionException, MBeanException, AttributeNotFoundException, IntrospectionException {
        return this.gson.toJson(this.collectMeasurements());
    }

    @Override
    public Map<String, Map<String, Object>> collectMeasurements(String category) throws InstanceNotFoundException, ReflectionException, MBeanException, AttributeNotFoundException, IntrospectionException {
        return this.collectMeasurements(category, (Map<Object, PresentationInformation>)null);
    }

    public Map<String, Map<String, Object>> collectMeasurements(String category, Map<Object, PresentationInformation> presentationInformation) throws InstanceNotFoundException, ReflectionException, MBeanException, AttributeNotFoundException, IntrospectionException {
        HashMap<String, Map<String, Object>> answer = new HashMap<String, Map<String, Object>>();
        for (Configuration configuration : this.configurations) {
            if (!configuration.getPresentationInformation().getCategory().equals(category)) continue;
            for (ObjectName objectName : configuration.getMBeanFinder().getMatchingObjectNames()) {
                if (presentationInformation != null) {
                    LOG.log(Level.FINE, "PresentationInformation saved for: " + category + configuration.getMBeanCollector().getConstructedName(objectName));
                    presentationInformation.put(category + configuration.getMBeanCollector().getConstructedName(objectName), configuration.getPresentationInformation());
                }
                try {
                    answer.put(configuration.getMBeanCollector().getConstructedName(objectName), configuration.getMBeanCollector().getValues(objectName));
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, t.getMessage(), t);
                }
            }
        }
        return answer;
    }

    @Override
    public String collectMeasurementsAsJSON(String category) throws InstanceNotFoundException, ReflectionException, MBeanException, AttributeNotFoundException, IntrospectionException {
        return this.gson.toJson(this.collectMeasurements(category));
    }

    @Override
    public Map<String, Object> collectMeasurements(String category, String name) throws InstanceNotFoundException, ReflectionException, MBeanException, AttributeNotFoundException, IntrospectionException {
        for (Configuration configuration : this.configurations) {
            if (!configuration.getPresentationInformation().getCategory().equals(category)) continue;
            for (ObjectName objectName : configuration.getMBeanFinder().getMatchingObjectNames()) {
                if (!configuration.getMBeanCollector().getConstructedName(objectName).equals(name)) continue;
                return configuration.getMBeanCollector().getValues(objectName);
            }
        }
        return null;
    }

    @Override
    public String collectMeasurementsAsJSON(String category, String name) throws InstanceNotFoundException, ReflectionException, MBeanException, AttributeNotFoundException, IntrospectionException {
        return this.gson.toJson(this.collectMeasurements(category, name));
    }

    @Override
    public Object collectMeasurement(String category, String name, String attribute) throws InstanceNotFoundException, ReflectionException, MBeanException, AttributeNotFoundException, IntrospectionException {
        return this.collectMeasurements(category, name).get(attribute);
    }

    @Override
    public String collectMeasurementAsJSON(String category, String name, String attribute) throws InstanceNotFoundException, ReflectionException, MBeanException, AttributeNotFoundException, IntrospectionException {
        return this.gson.toJson(this.collectMeasurement(category, name, attribute));
    }

    private void deactivateThresholds() {
        LOG.log(Level.FINE, "Stopping threshold threads");
        for (ThresholdThread t : this.thresholdThreads.values()) {
            t.stopThread();
            t.interrupt();
        }
        this.thresholdThreads.clear();
    }

    private void activateThresholds() {
        for (Configuration configuration : this.configurations) {
            for (Map.Entry<String, Threshold> entry : configuration.getThresholds().entrySet()) {
                Threshold threshold = entry.getValue();
                if (!this.thresholdThreads.containsKey(threshold.getInterval())) {
                    String threadName = "JMole Threshold Thread: " + threshold.getInterval() + " ms";
                    LOG.log(Level.FINE, "Starting thread: " + threadName);
                    ThresholdThread thread = new ThresholdThread(threadName, threshold.getInterval(), this);
                    thread.start();
                    this.thresholdThreads.put(threshold.getInterval(), thread);
                    continue;
                }
                LOG.log(Level.FINE, "Thread already exists for " + threshold.getInterval());
            }
        }
    }

    @Override
    public Map<String, Map<String, String>> warningMessages() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        return this.constructMessageData(true);
    }

    @Override
    public String warningMessagesAsJSON() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        return this.gson.toJson(this.constructMessageData(true));
    }

    @Override
    public Map<String, Map<String, String>> criticalMessages() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        return this.constructMessageData(false);
    }

    @Override
    public String criticalMessagesAsJSON() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        return this.gson.toJson(this.constructMessageData(false));
    }

    private Map<String, Map<String, String>> constructMessageData(boolean warning) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        HashMap<String, Map<String, String>> answer = new HashMap<String, Map<String, String>>();
        for (ThresholdThread t : this.thresholdThreads.values()) {
            Set<Map.Entry<ObjectName, String>> entrySet = null;
            entrySet = warning ? t.getWarningMessages().entrySet() : t.getCriticalMessages().entrySet();
            HashMap<String, String> thresholdMap = new HashMap<String, String>();
            String category = null;
            for (Map.Entry<ObjectName, String> entry : entrySet) {
                ObjectName objectName = entry.getKey();
                String msg = entry.getValue();
                thresholdMap.put(t.getConfiguration(objectName).getMBeanCollector().getConstructedName(objectName), msg);
                category = t.getConfiguration(objectName).getPresentationInformation().getCategory();
            }
            if (thresholdMap.isEmpty()) continue;
            answer.put(category, thresholdMap);
        }
        return answer;
    }

    @Override
    public int getLevel() {
        return Integer.getInteger(CONFIG_LEVEL_PROPERTY, 3);
    }

    @Override
    public int getNumberOfThresholdThreads() {
        return this.thresholdThreads.size();
    }

    @Override
    public int getNumberOfConfigurations() {
        return this.configurations.size();
    }

    @Override
    public int getNumberOfThresholds() {
        int answer = 0;
        for (Configuration configuration : this.configurations) {
            answer += configuration.getThresholds().size();
        }
        return answer;
    }

    @Override
    public String[] getAllJMoleSystemProperties() {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith("jmole.")) continue;
            list.add(key + "=" + System.getProperty(key));
        }
        String[] answer = new String[list.size()];
        answer = list.toArray(answer);
        return answer;
    }

    private static class SimpleExceptionListener
    implements ExceptionListener {
        private Exception e = null;

        private SimpleExceptionListener() {
        }

        @Override
        public void exceptionThrown(Exception e) {
            this.e = e;
        }

        Exception getException() {
            return this.e;
        }
    }
}

