/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole.protocols.nrpe;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import net.welen.jmole.protocols.nrpe.NRPE;
import net.welen.jmole.protocols.nrpe.NRPEMessage;

public class NRPESocketHandler
extends Thread {
    private static final Logger LOG = Logger.getLogger(NRPESocketHandler.class.getName());
    private Socket socket;
    private NRPE setup;

    public NRPESocketHandler(Socket socket, NRPE setup) {
        this.socket = socket;
        this.setup = setup;
        this.setName("JMole NRPE protocol thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        FilterInputStream in = null;
        FilterOutputStream out = null;
        try {
            this.socket.setSoTimeout(this.setup.getTcpReadTimeOut());
            in = new DataInputStream(this.socket.getInputStream());
            out = new DataOutputStream(this.socket.getOutputStream());
            NRPEMessage request = new NRPEMessage((DataInputStream)in);
            LOG.log(Level.FINE, "Incoming message: " + request.toString());
            NRPEMessage answer = null;
            String[] commands = request.getBufferAsString().split("!");
            String command = null;
            if (commands.length == 0) {
                answer = new NRPEMessage(request.getVersion(), 2, 3, "Missing command in buffer".getBytes());
            } else {
                command = commands[0];
                Integer maxMessageSize = this.setup.getMaxMessageSize();
                if (command.equals("checkWarnings")) {
                    String problems = this.setup.getJMole().warningMessages().toString();
                    if (problems.length() > maxMessageSize) {
                        problems = problems.substring(0, maxMessageSize);
                    }
                    answer = !problems.equals("{}") ? new NRPEMessage(request.getVersion(), 2, 1, problems.getBytes()) : new NRPEMessage(request.getVersion(), 2, 0, "No warnings detected".getBytes());
                } else if (command.equals("checkCriticals")) {
                    String problems = this.setup.getJMole().criticalMessages().toString();
                    if (problems.length() > maxMessageSize) {
                        problems = problems.substring(0, maxMessageSize);
                    }
                    answer = !problems.equals("{}") ? new NRPEMessage(request.getVersion(), 2, 2, problems.getBytes()) : new NRPEMessage(request.getVersion(), 2, 0, "No critical errors detected".getBytes());
                } else {
                    LOG.log(Level.SEVERE, "Unknown command: \"" + command + "\" in buffer in message: " + request.toString());
                    answer = new NRPEMessage(request.getVersion(), 2, 3, "Unknown command in buffer".getBytes());
                }
            }
            LOG.log(Level.FINE, "Outgoing message: " + answer.toString());
            answer.sendMessage((DataOutputStream)out);
            ((DataOutputStream)out).flush();
        }
        catch (SocketTimeoutException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (SocketException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (AttributeNotFoundException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (InstanceNotFoundException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (MBeanException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (ReflectionException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
                this.socket.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

