/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole.protocols.nrpe;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.zip.CRC32;

public class NRPEMessage {
    private static final Logger LOG = Logger.getLogger(NRPEMessage.class.getName());
    private int version = 0;
    private int type = 0;
    private int crc32 = 0;
    private int resultCode = 0;
    private int alignment = 0;
    private byte[] buffer;
    private int padding = 0;

    public NRPEMessage(DataInputStream in) throws IOException {
        int calcValue;
        this.version = in.readShort();
        this.type = in.readShort();
        this.crc32 = in.readInt();
        this.resultCode = in.readShort();
        if (this.version < 2 || this.version > 4) {
            throw new IOException("NRPE Version " + this.version + " not supported");
        }
        int bufferLength = 1024;
        if (this.version > 2) {
            this.alignment = in.readShort();
            bufferLength = in.readInt();
        }
        this.buffer = new byte[bufferLength];
        in.read(this.buffer);
        if (this.version == 2) {
            this.padding = in.readShort();
        }
        if (this.crc32 != (calcValue = this.calcCRC32())) {
            throw new IOException("CRC32 Error: " + this.crc32 + "!=" + calcValue);
        }
    }

    public NRPEMessage(int version, int type, int resultCode, byte[] buffer) {
        this.version = version;
        this.type = type;
        this.resultCode = resultCode;
        this.buffer = buffer;
    }

    public int getVersion() {
        return this.version;
    }

    public int getType() {
        return this.type;
    }

    public long getCRC32() {
        return this.crc32;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public void sendMessage(DataOutputStream out) throws IOException {
        byte[] data = this.toBytes(this.calcCRC32());
        out.write(data);
    }

    private byte[] toBytes(int crc32Value) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bytes);
        out.writeShort(this.version);
        out.writeShort(this.type);
        out.writeInt(crc32Value);
        out.writeShort(this.resultCode);
        if (this.version > 2) {
            out.writeShort(this.alignment);
            out.writeInt(this.buffer.length);
        }
        out.write(this.buffer);
        if (this.version == 2) {
            int length = 1024 - this.buffer.length;
            if (length > 0) {
                out.write(new byte[length]);
            }
            out.writeShort(this.padding);
        }
        out.close();
        return bytes.toByteArray();
    }

    private int calcCRC32() throws IOException {
        CRC32 crcAlg = new CRC32();
        crcAlg.update(this.toBytes(0));
        return (int)crcAlg.getValue();
    }

    public String getBufferAsString() {
        return new String(this.buffer).trim();
    }

    public String toString() {
        return "Version: " + this.version + ", type: " + this.type + ", crc32: " + this.crc32 + ", resultCode: " + this.resultCode + ", buffer: " + this.getBufferAsString() + ", alignment: " + this.alignment + ", padding: " + this.padding;
    }
}

