/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole.protocols.munin;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.welen.jmole.JMole;
import net.welen.jmole.presentation.PresentationInformation;
import net.welen.jmole.protocols.AbstractProtocol;
import net.welen.jmole.protocols.munin.MuninMBean;
import net.welen.jmole.protocols.munin.MuninSocketHandler;

public class Munin
extends AbstractProtocol
implements MuninMBean,
Runnable {
    private static final Logger LOG = Logger.getLogger(Munin.class.getName());
    private static String PROPERTY_MUNIN_NODENAME = "jmole.protocol.munin.nodeName";
    private static String PROPERTY_MUNIN_ADDRESS = "jmole.protocol.munin.address";
    private static String PROPERTY_MUNIN_PORT = "jmole.protocol.munin.port";
    private static String PROPERTY_MUNIN_TCP_READ_TIMOUT = "jmole.protocol.munin.tcpReadTimeOut";
    private static String PROPERTY_MUNIN_MAX_THREADS = "jmole.protocol.munin.maxThreads";
    private ServerSocket serverSocket;
    private String nodeName;
    private String address;
    private Integer port;
    private Integer tcpReadTimeOut;
    private Integer maxThreads = 5;
    private boolean stopped = false;
    private boolean socketStopped = true;
    protected int currentThreads;

    @Override
    public void startProtocol(JMole jmole) throws Exception {
        this.nodeName = System.getProperty(PROPERTY_MUNIN_NODENAME);
        this.address = System.getProperty(PROPERTY_MUNIN_ADDRESS);
        if (this.address == null) {
            this.address = "localhost";
        }
        this.port = Integer.getInteger(PROPERTY_MUNIN_PORT);
        if (this.port == null) {
            this.port = 4949;
        }
        this.tcpReadTimeOut = Integer.getInteger(PROPERTY_MUNIN_TCP_READ_TIMOUT);
        if (this.tcpReadTimeOut == null) {
            this.tcpReadTimeOut = 10000;
        }
        this.maxThreads = Integer.getInteger(PROPERTY_MUNIN_MAX_THREADS);
        if (this.maxThreads == null) {
            this.maxThreads = 5;
        }
        LOG.log(Level.INFO, "JMole Munin protocol starting; " + this.address + ":" + this.port);
        LOG.log(Level.FINE, this.tcpReadTimeOut + ", " + this.maxThreads);
        this.serverSocket = new ServerSocket(this.port, -1, InetAddress.getByName(this.address));
        this.serverSocket.setSoTimeout(1000);
        new Thread(this).start();
        super.startProtocol(jmole);
    }

    @Override
    public void stopProtocol() throws Exception {
        this.stopped = true;
        while (!this.socketStopped) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        super.stopProtocol();
        LOG.log(Level.INFO, "JMole Munin protocol stopped");
    }

    @Override
    public void run() {
        this.stopped = false;
        this.socketStopped = false;
        try {
            while (!this.stopped) {
                try {
                    Socket socket = this.serverSocket.accept();
                    new MuninSocketHandler(socket, this).start();
                }
                catch (SocketTimeoutException e) {
                    LOG.log(Level.FINEST, "SocketTimeoutException", e);
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Munin socket IOException", e);
                }
            }
        }
        finally {
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            this.socketStopped = true;
        }
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public void setPort(Integer port) {
        this.port = port;
    }

    @Override
    public Integer getTcpReadTimeOut() {
        return this.tcpReadTimeOut;
    }

    @Override
    public void setTcpReadTimeOut(Integer timeout) {
        this.tcpReadTimeOut = timeout;
    }

    @Override
    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    @Override
    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    @Override
    public Integer getCurrentThreads() {
        return this.currentThreads;
    }

    @Override
    public void handleWarning(String name, String attribute, PresentationInformation presentationInformation, String message) throws Exception {
    }

    @Override
    public void handleCritical(String name, String attribute, PresentationInformation presentationInformation, String message) throws Exception {
    }
}

