/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole.protocols.logstash;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocketFactory;
import net.welen.jmole.JMole;
import net.welen.jmole.presentation.PresentationInformation;
import net.welen.jmole.protocols.AbstractIntervalProtocol;
import net.welen.jmole.protocols.ProtocolMessagePlaceholder;
import net.welen.jmole.protocols.logstash.LogstashMBean;

public class Logstash
extends AbstractIntervalProtocol
implements LogstashMBean {
    private static final Logger LOG = Logger.getLogger(Logstash.class.getName());
    private static String PROPERTY_LOGSTASH_USESSL = "jmole.protocol.logstash.useSSL";
    private static String PROPERTY_LOGSTASH_HOST = "jmole.protocol.logstash.host";
    private static String PROPERTY_LOGSTASH_PORT = "jmole.protocol.logstash.port";
    private static String PROPERTY_LOGSTASH_KEEPALIVE = "jmole.protocol.logstash.keepAlive";
    private static String PROPERTY_LOGSTASH_INTERVAL = "jmole.protocol.logstash.interval";
    private Boolean useSSL;
    private String host;
    private Integer port;
    private Boolean keepAlive;
    private Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();
    private Socket socket;

    @Override
    public void startProtocol(JMole jmole) throws Exception {
        Long interval;
        this.useSSL = Boolean.getBoolean(PROPERTY_LOGSTASH_USESSL);
        if (this.useSSL == null) {
            this.useSSL = false;
        }
        this.host = System.getProperty(PROPERTY_LOGSTASH_HOST);
        if (this.host == null) {
            this.host = "localhost";
        }
        this.port = Integer.getInteger(PROPERTY_LOGSTASH_PORT);
        if (this.port == null) {
            this.port = 5000;
        }
        if ((interval = Long.getLong(PROPERTY_LOGSTASH_INTERVAL)) != null) {
            this.setInterval(interval);
        }
        this.keepAlive = Boolean.getBoolean(PROPERTY_LOGSTASH_KEEPALIVE);
        if (this.keepAlive == null) {
            this.keepAlive = false;
        }
        super.startProtocol(jmole);
        LOG.log(Level.INFO, "JMole Logstash protocol started: " + this.host + ":" + this.port + " interval=" + this.getInterval());
    }

    @Override
    public void stopProtocol() throws Exception {
        LOG.log(Level.INFO, "Stopping JMole Logstash protocol");
        super.stopProtocol();
        LOG.log(Level.INFO, "JMole Logstash protocol stopped");
    }

    @Override
    public boolean useSSL() {
        return this.useSSL;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean getKeepAlive() {
        return this.keepAlive;
    }

    @Override
    protected void handleMeasurement(String category, String name, String attribute, Object value, PresentationInformation presentationInformation) throws Exception {
        this.sendToLogstash(this.gson.toJson(new ProtocolMessagePlaceholder("metric", new Date(), null, category, name, attribute, value, presentationInformation)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToLogstash(String data) {
        LOG.log(Level.FINE, "Sending data to logstash: " + data);
        PrintWriter out = null;
        try {
            out = new PrintWriter(this.getSocketOutputStream());
            out.write(data + "\n");
            out.flush();
        }
        catch (IOException e) {
            this.socket = null;
            LOG.log(Level.SEVERE, "Couldn't send data to logstash: " + data, e);
        }
        finally {
            if (!this.keepAlive.booleanValue()) {
                this.socket = null;
            }
        }
    }

    private OutputStream getSocketOutputStream() throws UnknownHostException, IOException {
        if (this.socket == null) {
            this.socket = this.useSSL != false ? SSLSocketFactory.getDefault().createSocket(this.host, (int)this.port) : new Socket(this.host, (int)this.port);
        }
        return this.socket.getOutputStream();
    }

    @Override
    public void handleWarning(String name, String attribute, PresentationInformation presentationInformation, String message) throws Exception {
        this.sendToLogstash(this.gson.toJson(new ProtocolMessagePlaceholder("warning", new Date(), message, presentationInformation.getCategory(), name, attribute, null, presentationInformation)));
    }

    @Override
    public void handleCritical(String name, String attribute, PresentationInformation presentationInformation, String message) throws Exception {
        this.sendToLogstash(this.gson.toJson(new ProtocolMessagePlaceholder("critical", new Date(), message, presentationInformation.getCategory(), name, attribute, null, presentationInformation)));
    }
}

