/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole.protocols;

import java.math.BigDecimal;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.welen.jmole.presentation.PresentationInformation;

public class Utils {
    private static final Logger LOG = Logger.getLogger(Utils.class.getName());

    public static String formatLogString(String format, char sep, String category, String name, String attribute, Object value, PresentationInformation presentationInformation) {
        String answer = format;
        answer = answer.replace("%c", category);
        answer = answer.replace("%n", name);
        answer = answer.replace("%t", attribute);
        String key = String.format("%s%c%s%c%s", category, Character.valueOf(sep), name, Character.valueOf(sep), attribute);
        answer = answer.replace("%k", key);
        answer = answer.replace("%a", presentationInformation.translateAttributeLabel(attribute));
        String attributeDescription = presentationInformation.getAttributeDescription(attribute);
        answer = answer.replace("%A", attributeDescription != null ? attributeDescription : "");
        try {
            answer = answer.replace("%v", new BigDecimal(value.toString()).toPlainString());
        }
        catch (NumberFormatException e) {
            LOG.log(Level.FINE, e.getMessage() + ": " + key, e);
            answer = answer.replace("%v", value.toString());
        }
        answer = answer.replace("%U", presentationInformation.getUnit());
        return answer;
    }
}

