/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole.collector.extractor_impl;

import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.ObjectName;
import net.welen.jmole.Utils;
import net.welen.jmole.collector.AbstractDataCollectorExtractor;

public class RegExpDataExtractor
extends AbstractDataCollectorExtractor {
    protected static String REGEXP_PREFIX = "regexp_";
    protected static String VALUE_PREFIX = "value_";
    private SortedMap<String, String> sortedMap = null;

    @Override
    public void setProperties(Properties properties) {
        super.setProperties(properties);
        this.sortedMap = new TreeMap<Object, Object>(this.getProperties());
    }

    @Override
    public Object extractData(ObjectName objectName) throws Exception {
        String data = Utils.getMBeanServer().getAttribute(objectName, this.getAttribute()).toString();
        for (String key : this.sortedMap.keySet()) {
            if (!key.startsWith(REGEXP_PREFIX)) continue;
            String regex = (String)this.sortedMap.get(key);
            String replacement = (String)this.sortedMap.get(key.replace(REGEXP_PREFIX, VALUE_PREFIX));
            if (replacement == null) {
                throw new IllegalArgumentException("The regexp is missing a corresponding value: " + regex);
            }
            data = data.replaceAll(regex, replacement);
        }
        return data;
    }
}

