/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole.collector.extractor_impl;

import java.util.Properties;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import net.welen.jmole.Utils;
import net.welen.jmole.collector.AbstractDataCollectorExtractor;

public class CompositeDataExtractor
extends AbstractDataCollectorExtractor {
    private String attribute;
    private String name;

    @Override
    public void setProperties(Properties properties) {
        super.setProperties(properties);
        this.attribute = properties.getProperty("attribute");
        if (this.attribute == null) {
            throw new IllegalArgumentException("Property attribute can't be null");
        }
        this.name = properties.getProperty("name");
        if (this.name == null) {
            throw new IllegalArgumentException("Property name can't be null");
        }
    }

    @Override
    public Object extractData(ObjectName objectName) throws Exception {
        Object compositeData = Utils.getMBeanServer().getAttribute(objectName, this.attribute);
        if (compositeData == null) {
            return null;
        }
        if (compositeData instanceof CompositeData) {
            return ((CompositeData)compositeData).get(this.name);
        }
        throw new IllegalArgumentException("Found attribute is not a compositeData: " + compositeData.getClass().getName());
    }
}

