/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole.threshold;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import net.welen.jmole.Utils;
import net.welen.jmole.collector.MBeanCollector;
import net.welen.jmole.finder.MBeanFinder;
import net.welen.jmole.threshold.ThresholdValues;

public class Threshold
implements Runnable {
    private static final Logger LOG = Logger.getLogger(Threshold.class.getName());
    private boolean stopped = false;
    private int interval = 60000;
    private ThresholdValues thresholdValues = new ThresholdValues();
    private Map<String, ThresholdValues> individualThresholdValues = new HashMap<String, ThresholdValues>();
    private Map<ObjectName, String> warningMessages = new HashMap<ObjectName, String>();
    private Map<ObjectName, String> criticalMessages = new HashMap<ObjectName, String>();
    private MBeanFinder mBeanFinder;
    private MBeanCollector mBeanCollector;
    private String attribute;
    private String label;
    private String message = "%s";

    @Override
    public void run() {
        this.stopped = false;
        while (!this.stopped) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                LOG.log(Level.FINE, e.getMessage(), e);
            }
            LOG.log(Level.FINE, "Running threshold check");
            HashMap<ObjectName, String> newWarningMessages = new HashMap<ObjectName, String>();
            HashMap<ObjectName, String> newCriticalMessages = new HashMap<ObjectName, String>();
            for (ObjectName objectName : this.mBeanFinder.getMatchingObjectNames()) {
                try {
                    String high;
                    String low;
                    Boolean b;
                    if (this.stopped) {
                        return;
                    }
                    Object valueObject = this.mBeanCollector.getValues(objectName).get(this.attribute);
                    if (valueObject == null) {
                        LOG.log(Level.FINE, "Data collection returned null. Skipping it as it is probably not calculated yet");
                        continue;
                    }
                    Double value = null;
                    value = valueObject instanceof Boolean ? ((b = (Boolean)valueObject).booleanValue() ? Double.valueOf(1.0) : Double.valueOf(0.0)) : Double.valueOf(Double.parseDouble(valueObject.toString()));
                    ThresholdValues individualThresholdValue = this.individualThresholdValues.get(this.mBeanCollector.getConstructedName(objectName));
                    String message = this.message;
                    if (individualThresholdValue == null) {
                        low = this.getWarningLowThreshold();
                        high = this.getWarningHighThreshold();
                    } else {
                        low = individualThresholdValue.getWarningLowThreshold();
                        high = individualThresholdValue.getWarningHighThreshold();
                        if (individualThresholdValue.getMessage() != null) {
                            message = individualThresholdValue.getMessage();
                        }
                    }
                    low = Threshold.calculateThreshold(low, this.mBeanCollector, objectName, this.attribute);
                    high = Threshold.calculateThreshold(high, this.mBeanCollector, objectName, this.attribute);
                    if (!low.isEmpty() && value < Double.parseDouble(low)) {
                        newWarningMessages.put(objectName, this.constructMessage(message, this.getLabel() + ": " + value + " < " + low));
                    }
                    if (!high.isEmpty() && value > Double.parseDouble(high)) {
                        newWarningMessages.put(objectName, this.constructMessage(message, this.getLabel() + ": " + value + " > " + high));
                    }
                    message = this.message;
                    if (individualThresholdValue == null) {
                        low = this.getCriticalLowThreshold();
                        high = this.getCriticalHighThreshold();
                    } else {
                        low = individualThresholdValue.getCriticalLowThreshold();
                        high = individualThresholdValue.getCriticalHighThreshold();
                        if (individualThresholdValue.getMessage() != null) {
                            message = individualThresholdValue.getMessage();
                        }
                    }
                    low = Threshold.calculateThreshold(low, this.mBeanCollector, objectName, this.attribute);
                    high = Threshold.calculateThreshold(high, this.mBeanCollector, objectName, this.attribute);
                    if (!low.isEmpty() && value < Double.parseDouble(low)) {
                        newCriticalMessages.put(objectName, this.constructMessage(message, this.getLabel() + ": " + value + " < " + low));
                    }
                    if (high.isEmpty() || !(value > Double.parseDouble(high))) continue;
                    newCriticalMessages.put(objectName, this.constructMessage(message, this.getLabel() + ": " + value + " > " + high));
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, t.getMessage(), t);
                }
            }
            this.warningMessages = newWarningMessages;
            this.criticalMessages = newCriticalMessages;
        }
        LOG.log(Level.FINE, "Thread stopped");
    }

    private String constructMessage(String message, String problemText) {
        return String.format(message, problemText);
    }

    public void stopThread() {
        LOG.log(Level.FINE, "Stopping thread");
        this.stopped = true;
    }

    public String getCriticalLowThreshold() {
        return this.thresholdValues.getCriticalLowThreshold();
    }

    public void setCriticalLowThreshold(String criticalLowThreshold) {
        this.thresholdValues.setCriticalLowThreshold(criticalLowThreshold);
    }

    public String getCriticalHighThreshold() {
        return this.thresholdValues.getCriticalHighThreshold();
    }

    public void setCriticalHighThreshold(String criticalHighThreshold) {
        this.thresholdValues.setCriticalHighThreshold(criticalHighThreshold);
    }

    public String getWarningLowThreshold() {
        return this.thresholdValues.getWarningLowThreshold();
    }

    public void setWarningLowThreshold(String warningLowThreshold) {
        this.thresholdValues.setWarningLowThreshold(warningLowThreshold);
    }

    public String getWarningHighThreshold() {
        return this.thresholdValues.getWarningHighThreshold();
    }

    public void setWarningHighThreshold(String warningHighThreshold) {
        this.thresholdValues.setWarningHighThreshold(warningHighThreshold);
    }

    public void setIndividualThresholds(Map<String, ThresholdValues> individualThresholdValues) {
        this.individualThresholdValues = individualThresholdValues;
    }

    public Map<String, ThresholdValues> getIndividualThresholds() {
        return this.individualThresholdValues;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public Map<ObjectName, String> getWarningMessages() {
        return this.warningMessages;
    }

    public void setWarningMessages(Map<ObjectName, String> warningMessages) {
        this.warningMessages = warningMessages;
    }

    public Map<ObjectName, String> getCriticalMessages() {
        return this.criticalMessages;
    }

    public void setCriticalMessages(Map<ObjectName, String> criticalMessages) {
        this.criticalMessages = criticalMessages;
    }

    public void setMBeanFinder(MBeanFinder mBeanFinder) {
        this.mBeanFinder = mBeanFinder;
    }

    public void setMBeanCollector(MBeanCollector mBeanCollector) {
        this.mBeanCollector = mBeanCollector;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        return this.attribute;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public static String calculateThreshold(String thresholdString, MBeanCollector mbeanCollector, ObjectName objectName, String attribute) throws InstanceNotFoundException, ReflectionException, AttributeNotFoundException, MBeanException {
        String data = thresholdString;
        Map<String, Object> values = mbeanCollector.getValues(objectName);
        LOG.log(Level.FINE, "Before variable replacement: " + data);
        for (String attributeName : mbeanCollector.getAttributes()) {
            if (!values.containsKey(attributeName) || values.get(attributeName) == null) continue;
            String[] tmpSplit = data.split(",");
            for (int i = 0; i < tmpSplit.length; ++i) {
                if (!tmpSplit[i].equals(attributeName)) continue;
                tmpSplit[i] = values.get(attributeName).toString();
            }
            StringBuffer tmp = new StringBuffer();
            for (String part : tmpSplit) {
                if (tmp.length() > 0) {
                    tmp.append(",");
                }
                tmp.append(part);
            }
            data = tmp.toString();
        }
        LOG.log(Level.FINE, "After variable replacement: " + data);
        return Utils.rpnCalculate(data);
    }
}

