/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole.protocols.munin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import net.welen.jmole.Configuration;
import net.welen.jmole.collector.MBeanCollector;
import net.welen.jmole.finder.MBeanFinder;
import net.welen.jmole.presentation.PresentationInformation;
import net.welen.jmole.protocols.munin.Munin;
import net.welen.jmole.threshold.Threshold;
import net.welen.jmole.threshold.ThresholdValues;

public class MuninSocketHandler
extends Thread {
    private static final Logger LOG = Logger.getLogger(MuninSocketHandler.class.getName());
    private Socket socket;
    private Munin setup;

    public MuninSocketHandler(Socket socket, Munin setup) {
        this.socket = socket;
        this.setup = setup;
        this.setName("JMole Munin protocol thread #" + setup.currentThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String command;
            ++this.setup.currentThreads;
            this.socket.setSoTimeout(this.setup.getTcpReadTimeOut());
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
            PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"), true);
            boolean multigraph = false;
            boolean dirtyconfig = false;
            String greeting = "# munin node at " + this.socket.getLocalAddress().getHostAddress() + ":" + this.socket.getLocalPort();
            LOG.log(Level.FINE, "Sent greeting: " + greeting);
            out.println(greeting);
            int maxThreads = this.setup.getMaxThreads();
            if (this.setup.currentThreads > maxThreads) {
                out.println("# Max number of clients reached: " + maxThreads + ". Hanging up.");
                throw new IOException("Max number of clients reached: " + maxThreads);
            }
            while ((command = reader.readLine()) != null) {
                command = command.replaceAll("\\b\\s{2,}\\b", " ").trim().toLowerCase(Locale.ENGLISH);
                LOG.log(Level.FINE, "Incoming command: " + command);
                StringBuffer answer = new StringBuffer();
                if (command.equals("quit")) {
                    this.socket.close();
                    return;
                }
                if (command.equals("version")) {
                    answer.append("Munin JMole node version: " + this.getClass().getPackage().getImplementationVersion() + "\n");
                } else if (command.startsWith("list")) {
                    if (multigraph) {
                        answer.append("jmole\n");
                    } else {
                        LOG.log(Level.SEVERE, "cap multigraph not sent from server. JMole Munin protocol needs this functionality.");
                        answer.append("# cap multigraph not sent from server. JMole Munin protocol needs this functionality.\n");
                    }
                } else if (command.startsWith("cap")) {
                    if (command.contains("multigraph")) {
                        multigraph = true;
                    }
                    if (command.contains("dirtyconfig")) {
                        dirtyconfig = true;
                    }
                    answer.append("cap multigraph dirtyconfig\n");
                } else if (command.matches("config\\s+jmole")) {
                    answer.append(this.executeConfig(dirtyconfig));
                } else if (command.matches("fetch\\s+jmole")) {
                    answer.append(this.executeFetch());
                } else {
                    LOG.log(Level.WARNING, "Unknown command: " + command);
                    answer.append("# Unknown command\n");
                }
                LOG.log(Level.FINE, "Answer: " + answer);
                out.println(answer.toString());
            }
        }
        catch (SocketTimeoutException e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            --this.setup.currentThreads;
            try {
                this.socket.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    private String executeConfig(boolean dirtyconfig) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        StringBuilder answer = new StringBuilder();
        for (Configuration configuration : this.setup.jmole.getConfiguration()) {
            MBeanFinder finder = configuration.getMBeanFinder();
            if (finder.getMatchingObjectNames().isEmpty()) continue;
            MBeanCollector collector = configuration.getMBeanCollector();
            PresentationInformation presentationInformation = configuration.getPresentationInformation();
            for (ObjectName objectName : finder.getMatchingObjectNames()) {
                answer.append("multigraph " + this.fixForMunin(collector.getConstructedName(objectName)) + "\n");
                if (presentationInformation.getCategory() != null) {
                    answer.append("graph_category " + presentationInformation.getCategory() + "\n");
                }
                answer.append("graph_title " + collector.getConstructedName(objectName) + "\n");
                if (presentationInformation.getUnit() != null) {
                    answer.append("graph_vlabel " + presentationInformation.getUnit() + "\n");
                }
                if (presentationInformation.getDescription() != null) {
                    answer.append("graph_info " + presentationInformation.getDescription() + "\n");
                }
                answer.append("graph_printf %.0lf\n");
                for (String string : collector.getAttributes()) {
                    String high;
                    String low;
                    Threshold threshold;
                    String fixedAttribute = this.fixForMunin(string);
                    answer.append(fixedAttribute + ".label " + presentationInformation.translateAttributeLabel(string) + "\n");
                    String description = presentationInformation.getAttributeDescription(string);
                    if (description != null) {
                        answer.append(fixedAttribute + ".info " + description + "\n");
                    }
                    if ((threshold = configuration.getThresholds().get(string)) == null) continue;
                    ThresholdValues individualValues = threshold.getIndividualThresholds().get(collector.getConstructedName(objectName));
                    if (individualValues == null) {
                        low = threshold.getWarningLowThreshold();
                        high = threshold.getWarningHighThreshold();
                    } else {
                        low = individualValues.getWarningLowThreshold();
                        high = individualValues.getWarningHighThreshold();
                    }
                    String tmp = Threshold.calculateThreshold(low, collector, objectName, string) + ":" + Threshold.calculateThreshold(high, collector, objectName, string);
                    if (!tmp.equals(":")) {
                        answer.append(fixedAttribute + ".warning " + tmp + "\n");
                    }
                    if (individualValues == null) {
                        low = threshold.getCriticalLowThreshold();
                        high = threshold.getCriticalHighThreshold();
                    } else {
                        low = individualValues.getCriticalLowThreshold();
                        high = individualValues.getCriticalHighThreshold();
                    }
                    if ((tmp = Threshold.calculateThreshold(low, collector, objectName, string) + ":" + Threshold.calculateThreshold(high, collector, objectName, string)).equals(":")) continue;
                    answer.append(fixedAttribute + ".critical " + tmp + "\n");
                }
                if (!dirtyconfig) continue;
                for (Map.Entry entry : collector.getValues(objectName).entrySet()) {
                    String valueString = this.translateValue(entry.getValue());
                    answer.append(this.fixForMunin((String)entry.getKey()) + ".value " + valueString + "\n");
                }
            }
        }
        return answer.append(".\n").toString();
    }

    private String executeFetch() throws InstanceNotFoundException, ReflectionException, AttributeNotFoundException, MBeanException {
        StringBuilder answer = new StringBuilder();
        for (Configuration configuration : this.setup.jmole.getConfiguration()) {
            MBeanFinder finder = configuration.getMBeanFinder();
            MBeanCollector collector = configuration.getMBeanCollector();
            for (ObjectName objectName : finder.getMatchingObjectNames()) {
                answer.append("multigraph " + this.fixForMunin(collector.getConstructedName(objectName)) + "\n");
                for (Map.Entry<String, Object> entry : collector.getValues(objectName).entrySet()) {
                    String valueString = this.translateValue(entry.getValue());
                    answer.append(this.fixForMunin(entry.getKey()) + ".value " + valueString + "\n");
                }
            }
        }
        return answer.append(".\n").toString();
    }

    private String translateValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return "1";
            }
            return "0";
        }
        return value.toString();
    }

    private String fixForMunin(String input) {
        return input.replaceAll("[^a-zA-Z0-9]", "_");
    }
}

