/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole.protocols;

import java.math.BigDecimal;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.welen.jmole.presentation.PresentationInformation;

public class Utils {
    private static final Logger LOG = Logger.getLogger(Utils.class.getName());

    public static String formatLogString(String format, char sep, String category, String name, String attribute, Object value, PresentationInformation presentationInformation) {
        String answer = format;
        answer = answer.replaceAll("%c", category);
        answer = answer.replaceAll("%n", name);
        answer = answer.replaceAll("%t", attribute);
        String key = String.format("%s%c%s%c%s", category, Character.valueOf(sep), name, Character.valueOf(sep), attribute);
        answer = answer.replaceAll("%k", key);
        answer = answer.replaceAll("%a", presentationInformation.translateAttributeLabel(attribute));
        String attributeDescription = presentationInformation.getAttributeDescription(attribute);
        answer = answer.replaceAll("%A", attributeDescription != null ? attributeDescription : "");
        try {
            answer = answer.replaceAll("%v", new BigDecimal(value.toString()).toPlainString());
        }
        catch (NumberFormatException e) {
            LOG.log(Level.FINE, e.getMessage() + ": " + key, e);
            answer = answer.replaceAll("%v", value.toString());
        }
        answer = answer.replaceAll("%U", presentationInformation.getUnit());
        return answer;
    }
}

