/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole.collector.extractor_impl;

import java.util.Hashtable;
import java.util.Properties;
import javax.management.ObjectName;
import net.welen.jmole.Utils;
import net.welen.jmole.collector.AbstractDataCollectorExtractor;

public class SeparateMBeanDataExtractor
extends AbstractDataCollectorExtractor {
    private String attribute;
    private String objectNameString;

    @Override
    public void setProperties(Properties properties) {
        super.setProperties(properties);
        this.attribute = this.getProperties().getProperty("attribute");
        if (this.attribute == null) {
            throw new IllegalArgumentException("Property attribute can't be null");
        }
        this.objectNameString = this.getProperties().getProperty("objectName");
        if (this.objectNameString == null) {
            throw new IllegalArgumentException("Property objectName can't be null");
        }
    }

    @Override
    public Object extractData(ObjectName parentObjectName) throws Exception {
        ObjectName objectName = new ObjectName(this.objectNameString);
        String parentMBeanParameterToAdd = this.getProperties().getProperty("parentMBeanParameterToAdd");
        if (parentMBeanParameterToAdd != null) {
            String domain = objectName.getDomain();
            Hashtable<String, String> list = objectName.getKeyPropertyList();
            list.put(parentMBeanParameterToAdd, parentObjectName.getKeyProperty(parentMBeanParameterToAdd));
            objectName = new ObjectName(domain, list);
        }
        return Utils.getMBeanServer().getAttribute(objectName, this.attribute);
    }
}

