/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole.collector;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import net.welen.jmole.Utils;
import net.welen.jmole.collector.DataCollectorExtractor;
import net.welen.jmole.collector.MBeanCollector;

public class MBeanCollectorImpl
implements MBeanCollector {
    private static final Logger LOG = Logger.getLogger(MBeanCollectorImpl.class.getName());
    private MBeanServer server = Utils.getMBeanServer();
    private String name = "%s";
    private List<String> nameAttributes = null;
    private List<String> nameParameters = null;
    private List<Integer> nameDomainNameParts = null;
    private Map<String, Integer> counterIntervals = new HashMap<String, Integer>();
    private Map<String, LastFetch> lastFetchMap = new HashMap<String, LastFetch>();
    private List<String> attributes = new ArrayList<String>();
    private Map<String, DataCollectorExtractor> attributeExtractors = new HashMap<String, DataCollectorExtractor>();
    private Map<String, String> attributeRecalculations = new HashMap<String, String>();
    private Map<String, String> attributeFormatPatterns = new HashMap<String, String>();

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setNameAttributes(List<String> nameAttributes) {
        this.nameAttributes = nameAttributes;
    }

    @Override
    public void setNameParameters(List<String> nameParameters) {
        this.nameParameters = nameParameters;
    }

    public void setNameDomainNameParts(List<Integer> nameDomainNameParts) {
        this.nameDomainNameParts = nameDomainNameParts;
    }

    public Map<String, Integer> getCounterIntervals() {
        return this.counterIntervals;
    }

    public void setCounterIntervals(Map<String, Integer> counterIntervals) {
        this.counterIntervals = counterIntervals;
    }

    private String getNameSubstitution(ObjectName objectName) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        StringBuilder tmp = new StringBuilder();
        if (this.nameDomainNameParts != null) {
            String[] domainNameParts = objectName.getDomain().split("\\.");
            for (Integer pos : this.nameDomainNameParts) {
                if (tmp.length() > 0) {
                    tmp.append(" ");
                }
                tmp.append(domainNameParts[pos]);
            }
        }
        if (this.nameAttributes != null) {
            for (String part : this.nameAttributes) {
                if (tmp.length() > 0) {
                    tmp.append(" ");
                }
                tmp.append(this.server.getAttribute(objectName, part).toString());
            }
        }
        if (this.nameParameters != null) {
            for (String part : this.nameParameters) {
                if (tmp.length() > 0) {
                    tmp.append(" ");
                }
                tmp.append(objectName.getKeyProperty(part));
            }
        }
        if (tmp.length() == 0) {
            return null;
        }
        return tmp.toString();
    }

    @Override
    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    @Override
    public List<String> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setDataCollectorExtractors(Map<String, DataCollectorExtractor> attributeExtractors) {
        this.attributeExtractors = attributeExtractors;
    }

    @Override
    public void setAttributeRecalculations(Map<String, String> attributeRecalculations) {
        this.attributeRecalculations = attributeRecalculations;
    }

    @Override
    public void setAttributeFormatPatterns(Map<String, String> attributeFormatPatterns) {
        this.attributeFormatPatterns = attributeFormatPatterns;
    }

    @Override
    public String getConstructedName(ObjectName objectName) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        String substition = this.getNameSubstitution(objectName);
        if (substition != null) {
            return String.format(this.name, substition);
        }
        return this.name;
    }

    @Override
    public Map<String, Object> getValues(ObjectName objectName) throws InstanceNotFoundException, ReflectionException, AttributeNotFoundException, MBeanException {
        LOG.log(Level.FINE, "Getting the values for ObjectName: " + objectName);
        LOG.log(Level.FINE, "Attribute list: " + this.attributes);
        Object attributeList = null;
        try {
            ArrayList<String> tmpAttributes = new ArrayList<String>(this.attributes);
            for (DataCollectorExtractor extractor : this.attributeExtractors.values()) {
                if (!tmpAttributes.contains(extractor.getAttribute())) continue;
                tmpAttributes.remove(extractor.getAttribute());
            }
            attributeList = this.server.getAttributes(objectName, tmpAttributes.toArray(new String[0]));
        }
        catch (RuntimeException e) {
            LOG.log(Level.SEVERE, "Couldn't get the attributes: " + this.attributes + " for MBean: " + objectName, e);
            throw e;
        }
        LOG.log(Level.FINE, "AttributeList: " + attributeList);
        if (((ArrayList)attributeList).size() > this.attributes.size()) {
            LOG.log(Level.FINE, "Fixing JBoss MBean server bug. Got: " + attributeList + " expected only: " + this.attributes);
            AttributeList fixed = new AttributeList();
            for (Attribute value : ((AttributeList)attributeList).asList()) {
                if (!this.attributes.contains(value.getName())) continue;
                fixed.add(value);
            }
            attributeList = fixed;
        }
        if (((ArrayList)attributeList).size() != this.attributes.size()) {
            for (String attribute : this.attributes) {
                if (((ArrayList)attributeList).contains(attribute)) continue;
                try {
                    ((AttributeList)attributeList).add(new Attribute(attribute, this.server.getAttribute(objectName, attribute)));
                    LOG.log(Level.FINE, "Fixing JBoss MBean server bug for MBean: " + objectName + " and attribute: " + attribute);
                }
                catch (InstanceNotFoundException e) {
                    LOG.log(Level.FINE, e.getMessage(), e);
                }
                catch (ReflectionException e) {
                    LOG.log(Level.FINE, e.getMessage(), e);
                }
                catch (AttributeNotFoundException e) {
                    LOG.log(Level.FINE, e.getMessage(), e);
                }
                catch (MBeanException e) {
                    LOG.log(Level.FINE, e.getMessage(), e);
                }
            }
        }
        HashMap<String, Object> answer = new HashMap<String, Object>();
        for (Attribute attribute : ((AttributeList)attributeList).asList()) {
            Object value;
            String attributeName = attribute.getName();
            try {
                value = attribute.getValue();
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, t.getMessage(), t);
                continue;
            }
            boolean extractorHandled = false;
            for (DataCollectorExtractor extractor : this.attributeExtractors.values()) {
                if (!extractor.getAttribute().equals(attributeName)) continue;
                extractorHandled = true;
                break;
            }
            if (extractorHandled) continue;
            answer.put(attributeName, this.handleValue(objectName, attributeName, value));
        }
        LOG.log(Level.FINE, "DataCollectorExtractor attributes: " + this.attributeExtractors.keySet());
        for (DataCollectorExtractor extractor : this.attributeExtractors.values()) {
            Object value;
            LOG.log(Level.FINE, "DataCollectorExtractor found  ObjectName: " + objectName + " Attribute: " + extractor.getAttribute() + " Properties: " + extractor.getProperties());
            try {
                value = extractor.extractData(objectName);
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, t.getMessage(), t);
                continue;
            }
            answer.put(extractor.getAttribute(), this.handleValue(objectName, extractor.getAttribute(), value));
        }
        LOG.log(Level.FINE, "Returning: " + answer);
        return answer;
    }

    private Object handleValue(ObjectName objectName, String attributeName, Object value) {
        Double doubleValue;
        LOG.log(Level.FINE, "Attribute : " + attributeName + " value = " + value);
        if (this.counterIntervals.containsKey(attributeName)) {
            value = this.calculateCounterValue(objectName + "->" + attributeName, Double.parseDouble(value.toString()), this.counterIntervals.get(attributeName));
        }
        if (value == null) {
            LOG.log(Level.FINE, "Attribute: " + attributeName + " is null for ObjectName: " + objectName);
            return null;
        }
        if (this.attributeRecalculations.containsKey(attributeName)) {
            try {
                doubleValue = Double.parseDouble(value.toString());
                String reCalculation = this.attributeRecalculations.get(attributeName);
                value = Double.parseDouble(Utils.rpnCalculate(doubleValue + "," + reCalculation));
            }
            catch (NumberFormatException e) {
                LOG.log(Level.SEVERE, "Can't do recalculation on non decimal value: " + objectName + " " + value, e);
            }
        }
        if (this.attributeFormatPatterns.containsKey(attributeName)) {
            try {
                doubleValue = Double.parseDouble(value.toString());
                String pattern = this.attributeFormatPatterns.get(attributeName);
                DecimalFormat decimalFormat = new DecimalFormat(pattern);
                value = decimalFormat.format(doubleValue);
            }
            catch (NumberFormatException e) {
                LOG.log(Level.SEVERE, "Can't do formatting on non decimal value: " + objectName + " " + value, e);
            }
        }
        LOG.log(Level.FINE, "Attribute: " + attributeName + " is " + value + " for ObjectName: " + objectName);
        return value;
    }

    private Double calculateCounterValue(String key, Double value, int counterInterval) {
        LOG.log(Level.FINE, "Checking " + key);
        long now = System.currentTimeMillis();
        LastFetch lastFetch = this.lastFetchMap.get(key);
        if (lastFetch == null) {
            LOG.log(Level.FINE, "No earlier fetch available, skipping");
            this.lastFetchMap.put(key, new LastFetch(now, value, null));
            return null;
        }
        if (lastFetch.value > value) {
            LOG.log(Level.FINE, "Skipping and reset due to that " + lastFetch.value + " > " + value);
            this.lastFetchMap.put(key, new LastFetch(now, value, null));
            return null;
        }
        if (lastFetch.fetchTime + (long)counterInterval > now) {
            LOG.log(Level.FINE, "Returning last know calculated value due to that the counter interval " + counterInterval + " ms is not reached: " + (lastFetch.fetchTime + (long)counterInterval) + " > " + now);
            return lastFetch.lastCalculatedValue;
        }
        Double calculatedValue = (value - lastFetch.value) / ((double)(now - lastFetch.fetchTime) / (double)counterInterval);
        this.lastFetchMap.put(key, new LastFetch(now, value, calculatedValue));
        LOG.log(Level.FINE, "Returning calculated value: " + calculatedValue);
        return calculatedValue;
    }

    private static class LastFetch {
        long fetchTime;
        Double value;
        Double lastCalculatedValue;

        public LastFetch(long fetchTime, Double value, Double lastCalculatedValue) {
            this.fetchTime = fetchTime;
            this.value = value;
            this.lastCalculatedValue = lastCalculatedValue;
        }
    }
}

