/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.welen.jmole.JMole;
import net.welen.jmole.Utils;
import net.welen.jmole.protocols.MBeanProtocol;
import net.welen.jmole.protocols.Protocol;
import net.welen.jmole.protocols.logger.Logger;
import net.welen.jmole.protocols.logstash.Logstash;
import net.welen.jmole.protocols.munin.Munin;

public class Lifecycle {
    private static final java.util.logging.Logger LOG = java.util.logging.Logger.getLogger(Lifecycle.class.getName());
    private static final String PROTOCOLS_PROPERTY_PREFIX = "jmole.protocol.";
    private static final String PROTOCOLS_PROPERTY_ENABLED_SUFFIX = ".enabled";
    private static final String PROTOCOLS_PROPERTY_CLASSNAME_SUFFIX = ".classname";
    private static final String PROTOCOLS_PROPERTY_JAR_SUFFIX = ".jars";
    private static final String NRPE_JAR_NAME = "protocols/jmole-core-protocol-jar-with-dependencies.jar";
    private static final String ZABBIX_JAR_NAME = "protocols/jmole-protocol-zabbix-jar-with-dependencies.jar";
    private static final String STATSD_JAR_NAME = "protocols/jmole-protocol-statsd-jar-with-dependencies.jar";
    private static final String SYSLOG_JAR_NAME = "protocols/jmole-protocol-syslog-jar-with-dependencies.jar";
    private static final String CLOUDWATCH_JAR_NAME = "protocols/jmole-protocol-cloudwatch-jar-with-dependencies.jar";
    private static final String PROTOCOL_MBEAN_NAME_PREFIX = "net.welen.jmole.protocol:name=";
    private static JMole jmole;
    private static boolean running;
    private static MBeanServer server;
    private static List<Protocol> protocols;

    public static synchronized void setup() {
        if (running) {
            return;
        }
        running = true;
        LOG.log(Level.INFO, "Starting JMole");
        try {
            jmole = new JMole();
            jmole.register();
            jmole.configure();
            if (Boolean.getBoolean("jmole.protocol.logger.enabled")) {
                System.setProperty("jmole.protocol.logger.classname", Logger.class.getCanonicalName());
            }
            if (Boolean.getBoolean("jmole.protocol.munin.enabled")) {
                System.setProperty("jmole.protocol.munin.classname", Munin.class.getCanonicalName());
            }
            if (Boolean.getBoolean("jmole.protocol.logstash.enabled")) {
                System.setProperty("jmole.protocol.logstash.classname", Logstash.class.getCanonicalName());
            }
            if (Boolean.getBoolean("jmole.protocol.nrpe.enabled")) {
                System.setProperty("jmole.protocol.nrpe.classname", "net.welen.jmole.protocols.nrpe.NRPE");
                System.setProperty("jmole.protocol.nrpe.jars", Lifecycle.exportJar(NRPE_JAR_NAME));
            }
            if (Boolean.getBoolean("jmole.protocol.zabbix.enabled")) {
                System.setProperty("jmole.protocol.zabbix.classname", "net.welen.jmole.protocols.zabbix.Zabbix");
                System.setProperty("jmole.protocol.zabbix.jars", Lifecycle.exportJar(ZABBIX_JAR_NAME));
            }
            if (Boolean.getBoolean("jmole.protocol.statsd.enabled")) {
                System.setProperty("jmole.protocol.statsd.classname", "net.welen.jmole.protocols.statsd.Statsd");
                System.setProperty("jmole.protocol.statsd.jars", Lifecycle.exportJar(STATSD_JAR_NAME));
            }
            if (Boolean.getBoolean("jmole.protocol.syslog.enabled")) {
                System.setProperty("jmole.protocol.syslog.classname", "net.welen.jmole.protocols.syslog.Syslog");
                System.setProperty("jmole.protocol.syslog.jars", Lifecycle.exportJar(SYSLOG_JAR_NAME));
            }
            if (Boolean.getBoolean("jmole.protocol.cloudwatch.enabled")) {
                System.setProperty("jmole.protocol.cloudwatch.classname", "net.welen.jmole.protocols.cloudwatch.CloudWatch");
                System.setProperty("jmole.protocol.cloudwatch.jars", Lifecycle.exportJar(CLOUDWATCH_JAR_NAME));
            }
            Lifecycle.loadProtocols();
            for (Protocol protocol : protocols) {
                try {
                    protocol.startProtocol(jmole);
                    if (!(protocol instanceof MBeanProtocol)) continue;
                    server.registerMBean(protocol, Lifecycle.getProtocolObjectName(protocol));
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "Problem starting protocol: " + protocol.getName(), t);
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static void cleanup() {
        LOG.log(Level.INFO, "Stopping JMole");
        try {
            for (Protocol protocol : protocols) {
                try {
                    protocol.stopProtocol();
                    if (!(protocol instanceof MBeanProtocol)) continue;
                    server.unregisterMBean(Lifecycle.getProtocolObjectName(protocol));
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "Problem stopping protocol: " + protocol.getName(), t);
                }
            }
            jmole.unregister();
            running = false;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static ObjectName getProtocolObjectName(Protocol protocol) throws MalformedObjectNameException {
        return new ObjectName(PROTOCOL_MBEAN_NAME_PREFIX + protocol.getName());
    }

    public static JMole getJMoleInstance() {
        return jmole;
    }

    private static void loadProtocols() throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, MalformedURLException {
        protocols = new ArrayList<Protocol>();
        for (Object prop : System.getProperties().keySet()) {
            String propString;
            if (!(prop instanceof String) || !(propString = (String)prop).startsWith(PROTOCOLS_PROPERTY_PREFIX) || !propString.endsWith(PROTOCOLS_PROPERTY_ENABLED_SUFFIX) || !Boolean.getBoolean(propString)) continue;
            String protocolName = propString.replaceFirst("^jmole.protocol.", "").replaceFirst(".enabled$", "");
            LOG.log(Level.INFO, "Loading protocol: " + protocolName);
            String systemPropertyClassname = PROTOCOLS_PROPERTY_PREFIX + protocolName + PROTOCOLS_PROPERTY_CLASSNAME_SUFFIX;
            String systemPropertyJARfiles = PROTOCOLS_PROPERTY_PREFIX + protocolName + PROTOCOLS_PROPERTY_JAR_SUFFIX;
            String className = System.getProperty(systemPropertyClassname);
            if (className != null) {
                Class<?> clazz;
                String jarNames = System.getProperty(systemPropertyJARfiles);
                if (jarNames == null) {
                    LOG.log(Level.INFO, "No protocol jars to load");
                    clazz = Class.forName(className);
                } else {
                    LOG.log(Level.INFO, "Loading protocol jars: " + jarNames);
                    ArrayList<URL> urls = new ArrayList<URL>();
                    for (String jar : jarNames.split(",")) {
                        urls.add(new URL(jar));
                    }
                    URL[] urlArray = new URL[urls.size()];
                    urlArray = urls.toArray(urlArray);
                    clazz = Class.forName(className, true, new URLClassLoader(urlArray, Lifecycle.class.getClassLoader()));
                }
                Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                Protocol p = (Protocol)ctor.newInstance(new Object[0]);
                p.setName(protocolName);
                protocols.add(p);
                continue;
            }
            LOG.log(Level.SEVERE, "Protocol enabled but no classname found using system property: " + systemPropertyClassname);
        }
    }

    private static String exportJar(String jarName) {
        try {
            int bytesRead;
            LOG.log(Level.FINE, "Loading internal jar: " + jarName);
            InputStream resourceAsStream = Lifecycle.class.getClassLoader().getResourceAsStream(jarName);
            File tempFile = File.createTempFile("jmoleJar", ".jar");
            tempFile.deleteOnExit();
            FileOutputStream out = new FileOutputStream(tempFile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = resourceAsStream.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            try {
                out.close();
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Couldn't close file", e);
            }
            return "file://" + tempFile.getAbsolutePath();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Couldn't export internal JAR: " + jarName, e);
            return null;
        }
    }

    static {
        running = false;
        server = Utils.getMBeanServer();
        protocols = new ArrayList<Protocol>();
    }
}

