/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole.protocols.logstash;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocketFactory;
import net.welen.jmole.JMole;
import net.welen.jmole.presentation.PresentationInformation;
import net.welen.jmole.protocols.AbstractIntervalProtocol;
import net.welen.jmole.protocols.MBeanProtocol;
import net.welen.jmole.protocols.logstash.LogstashMBean;
import net.welen.jmole.protocols.logstash.LogstashMessage;

public class Logstash
extends AbstractIntervalProtocol
implements MBeanProtocol,
LogstashMBean {
    private static final Logger LOG = Logger.getLogger(Logstash.class.getName());
    private static String PROPERTY_LOGSTASH_USESSL = "jmole.protocol.logstash.useSSL";
    private static String PROPERTY_LOGSTASH_HOST = "jmole.protocol.logstash.host";
    private static String PROPERTY_LOGSTASH_PORT = "jmole.protocol.logstash.port";
    private static String PROPERTY_LOGSTASH_KEEPALIVE = "jmole.protocol.logstash.keepAlive";
    private static String PROPERTY_LOGSTASH_INTERVAL = "jmole.protocol.logstash.interval";
    private Boolean useSSL;
    private String host;
    private Integer port;
    private Long interval;
    private Boolean keepAlive;
    private JMole jmole;
    private Gson gson = new Gson();
    private Socket socket;

    @Override
    public void startProtocol(JMole jmole) throws Exception {
        this.jmole = jmole;
        this.useSSL = Boolean.getBoolean(PROPERTY_LOGSTASH_USESSL);
        if (this.useSSL == null) {
            this.useSSL = false;
        }
        this.host = System.getProperty(PROPERTY_LOGSTASH_HOST);
        if (this.host == null) {
            this.host = "localhost";
        }
        this.port = Integer.getInteger(PROPERTY_LOGSTASH_PORT);
        if (this.port == null) {
            this.port = 5000;
        }
        this.interval = Long.getLong(PROPERTY_LOGSTASH_INTERVAL);
        if (this.interval == null) {
            this.interval = 60000L;
        }
        this.keepAlive = Boolean.getBoolean(PROPERTY_LOGSTASH_KEEPALIVE);
        if (this.keepAlive == null) {
            this.keepAlive = false;
        }
        super.startProtocol(jmole);
        LOG.log(Level.INFO, "JMole Logstash protocol started: " + this.host + ":" + this.port + " interval=" + this.interval);
    }

    @Override
    public void stopProtocol() throws Exception {
        LOG.log(Level.INFO, "Stopping JMole Logstash protocol");
        super.stopProtocol();
        LOG.log(Level.INFO, "JMole Logstash protocol stopped");
    }

    @Override
    public boolean useSSL() {
        return this.useSSL;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean getKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public long getInterval() {
        return this.interval;
    }

    @Override
    public void setInterval(long interval) {
        this.interval = interval;
    }

    @Override
    protected void handleMeasurement(String category, String name, String attribute, Object value, PresentationInformation presentationInformation) throws Exception {
        this.sendToLogstash(this.gson.toJson(new LogstashMessage("measurement", null, category, name, attribute, value, presentationInformation)));
    }

    @Override
    protected void handleWarnings() throws Exception {
        Gson gson = new Gson();
        for (Map.Entry<String, Map<String, String>> categoryEntry : this.jmole.warningMessages().entrySet()) {
            for (Map.Entry<String, String> entry : categoryEntry.getValue().entrySet()) {
                this.sendToLogstash(gson.toJson(new LogstashMessage("warning", entry.getValue(), categoryEntry.getKey(), entry.getKey(), null, null, null)));
            }
        }
    }

    @Override
    protected void handleCriticals() throws Exception {
        Gson gson = new Gson();
        for (Map.Entry<String, Map<String, String>> categoryEntry : this.jmole.criticalMessages().entrySet()) {
            for (Map.Entry<String, String> entry : categoryEntry.getValue().entrySet()) {
                this.sendToLogstash(gson.toJson(new LogstashMessage("critical", entry.getValue(), categoryEntry.getKey(), entry.getKey(), null, null, null)));
            }
        }
    }

    private void sendToLogstash(String data) {
        LOG.log(Level.FINE, "Sending data to logstash: " + data);
        PrintWriter out = null;
        try {
            out = new PrintWriter(this.getSocketOutputStream());
            out.write(data + "\n");
            out.flush();
        }
        catch (IOException e) {
            this.socket = null;
            LOG.log(Level.SEVERE, "Couldn't send data to logstash: " + data, e);
        }
    }

    private OutputStream getSocketOutputStream() throws UnknownHostException, IOException {
        if (this.socket == null) {
            this.socket = this.useSSL != false ? SSLSocketFactory.getDefault().createSocket(this.host, (int)this.port) : new Socket(this.host, (int)this.port);
        }
        return this.socket.getOutputStream();
    }
}

