/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole.protocols.logger;

import java.util.Map;
import java.util.logging.Level;
import net.welen.jmole.JMole;
import net.welen.jmole.presentation.PresentationInformation;
import net.welen.jmole.protocols.AbstractIntervalProtocol;
import net.welen.jmole.protocols.Utils;
import net.welen.jmole.protocols.logger.LoggerMBean;

public class Logger
extends AbstractIntervalProtocol
implements LoggerMBean {
    private static final java.util.logging.Logger LOG = java.util.logging.Logger.getLogger(Logger.class.getName());
    private static final char SEP = '/';
    private static String PROPERTY_LOGGER_NAME = "jmole.protocol.logger.name";
    private static String PROPERTY_LOGGER_FORMAT = "jmole.protocol.logger.format";
    private static String PROPERTY_LOGGER_LEVEL = "jmole.protocol.logger.level";
    private static String PROPERTY_LOGGER_INTERVAL = "jmole.protocol.logger.interval";
    private Level level;
    private String format;
    private Long interval;
    private java.util.logging.Logger protocolLogger = java.util.logging.Logger.getLogger("JMole");
    private JMole jmole;

    @Override
    public void startProtocol(JMole jmole) throws Exception {
        this.jmole = jmole;
        String levelString = System.getProperty(PROPERTY_LOGGER_LEVEL);
        if (levelString == null) {
            levelString = "INFO";
        }
        this.level = Level.parse(levelString);
        String name = System.getProperty(PROPERTY_LOGGER_NAME);
        if (name != null) {
            this.protocolLogger = java.util.logging.Logger.getLogger(name);
        }
        this.format = System.getProperty(PROPERTY_LOGGER_FORMAT);
        if (this.format == null) {
            this.format = "[%k] %a [%A] = %v %U";
        }
        this.interval = Long.getLong(PROPERTY_LOGGER_INTERVAL);
        if (this.interval == null) {
            this.interval = 60000L;
        }
        super.startProtocol(jmole);
        LOG.log(Level.INFO, "JMole Logger protocol started: Level=" + levelString + ", Interval=" + this.interval);
    }

    @Override
    public void stopProtocol() throws Exception {
        LOG.log(Level.INFO, "Stopping JMole Logger protocol");
        super.stopProtocol();
        LOG.log(Level.INFO, "JMole Logger protocol stopped");
    }

    @Override
    public String getLevel() {
        return this.level.getName();
    }

    @Override
    public void setLevel(String level) {
        this.level = Level.parse(level);
    }

    @Override
    public long getInterval() {
        return this.interval;
    }

    @Override
    public void setInterval(long interval) {
        this.interval = interval;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected void handleMeasurement(String category, String name, String attribute, Object value, PresentationInformation presentationInformation) throws Exception {
        this.protocolLogger.log(this.level, Utils.formatLogString(this.format, '/', category, name, attribute, value, presentationInformation));
    }

    @Override
    protected void handleWarnings() throws Exception {
        for (Map.Entry<String, Map<String, String>> categoryEntry : this.jmole.warningMessages().entrySet()) {
            for (Map.Entry<String, String> entry : categoryEntry.getValue().entrySet()) {
                this.protocolLogger.log(Level.WARNING, "[" + categoryEntry.getKey() + '/' + entry.getKey() + "] " + entry.getValue());
            }
        }
    }

    @Override
    protected void handleCriticals() throws Exception {
        for (Map.Entry<String, Map<String, String>> categoryEntry : this.jmole.criticalMessages().entrySet()) {
            for (Map.Entry<String, String> entry : categoryEntry.getValue().entrySet()) {
                this.protocolLogger.log(Level.SEVERE, "[" + categoryEntry.getKey() + '/' + entry.getKey() + "] " + entry.getValue());
            }
        }
    }
}

