/*
 * Decompiled with CFR 0.152.
 */
package net.welen.jmole.finder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import net.welen.jmole.Utils;
import net.welen.jmole.finder.MBeanFinder;

public class MBeanFinderImpl
implements MBeanFinder {
    private static final Logger LOG = Logger.getLogger(MBeanFinderImpl.class.getName());
    private MBeanServer server = Utils.getMBeanServer();
    private Set<ObjectName> matchingObjectNames = new HashSet<ObjectName>();
    private List<ObjectName> objectNameQueries = new ArrayList<ObjectName>();
    private String attributeName = null;
    private String attributeMatch = null;
    private String parameterName = null;
    private String parameterMatch = null;
    private String className = null;

    @Override
    public Set<ObjectName> getMatchingObjectNames() {
        return this.matchingObjectNames;
    }

    @Override
    public void updateMatchingObjectNames() throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IntrospectionException {
        HashSet<ObjectName> objectNames = new HashSet<ObjectName>();
        for (ObjectName query : this.objectNameQueries) {
            objectNames.addAll(this.server.queryNames(query, null));
        }
        LOG.log(Level.FINE, "Found ObjectNames: " + objectNames);
        HashSet<ObjectName> filteredObjectNames = new HashSet<ObjectName>();
        for (ObjectName objectName : objectNames) {
            LOG.log(Level.FINE, "Checking ObjectName: " + objectName);
            if (!this.attributeMatch(objectName)) {
                LOG.log(Level.FINE, "Removing ObjectName: " + objectName);
                continue;
            }
            if (!this.parameterMatch(objectName)) {
                LOG.log(Level.FINE, "Removing ObjectName: " + objectName);
                continue;
            }
            if (!this.classNameCheck(objectName)) {
                LOG.log(Level.FINE, "Removing ObjectName: " + objectName);
                continue;
            }
            filteredObjectNames.add(objectName);
        }
        LOG.log(Level.FINE, "Updated ObjectNames: " + filteredObjectNames);
        this.matchingObjectNames = filteredObjectNames;
    }

    @Override
    public void setObjectNameQueries(List<String> objectNameQuerys) throws MalformedObjectNameException {
        this.objectNameQueries = new ArrayList<ObjectName>();
        for (String query : objectNameQuerys) {
            this.objectNameQueries.add(new ObjectName(query));
        }
    }

    @Override
    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    @Override
    public void setAttributeMatch(String attributeMatch) {
        this.attributeMatch = attributeMatch;
    }

    @Override
    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    @Override
    public void setParameterMatch(String parameterMatch) {
        this.parameterMatch = parameterMatch;
    }

    @Override
    public void setClassName(String className) {
        this.className = className;
    }

    private boolean attributeMatch(ObjectName objectName) throws MBeanException, InstanceNotFoundException, ReflectionException {
        if (this.attributeName == null || this.attributeMatch == null) {
            return true;
        }
        try {
            Object attribute = this.server.getAttribute(objectName, this.attributeName);
            return attribute.toString().matches(this.attributeMatch);
        }
        catch (AttributeNotFoundException e) {
            LOG.log(Level.FINE, "Attribute: " + this.attributeName + " not found for: " + objectName + ". Assuming it's not a match", e);
            return false;
        }
    }

    private boolean parameterMatch(ObjectName objectName) throws MBeanException, InstanceNotFoundException, ReflectionException {
        if (this.parameterName == null || this.parameterMatch == null) {
            return true;
        }
        String parameter = objectName.getKeyProperty(this.parameterName);
        return parameter.matches(this.parameterMatch);
    }

    private boolean classNameCheck(ObjectName objectName) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IntrospectionException {
        if (this.className == null) {
            return true;
        }
        return this.server.getMBeanInfo(objectName).getClassName().equals(this.className);
    }
}

