/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.webservice.soap;

import jakarta.activation.DataHandler;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebServiceFeature;
import java.net.URL;
import javax.xml.namespace.QName;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.schema.operation.BillingType;
import net.webpdf.wsclient.schema.operation.OcrType;
import net.webpdf.wsclient.schema.operation.OperationData;
import net.webpdf.wsclient.schema.operation.PdfPasswordType;
import net.webpdf.wsclient.schema.operation.SettingsType;
import net.webpdf.wsclient.schema.stubs.OCR;
import net.webpdf.wsclient.schema.stubs.WebServiceException;
import net.webpdf.wsclient.session.soap.SoapSession;
import net.webpdf.wsclient.session.soap.documents.SoapDocument;
import net.webpdf.wsclient.webservice.WebServiceType;
import net.webpdf.wsclient.webservice.soap.SoapWebService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OcrWebService<T_SOAP_DOCUMENT extends SoapDocument>
extends SoapWebService<OCR, OcrType, T_SOAP_DOCUMENT> {
    public OcrWebService(@NotNull SoapSession<T_SOAP_DOCUMENT> session) throws ResultException {
        super(session, WebServiceType.OCR);
    }

    @Override
    @Nullable
    protected DataHandler processService(@NotNull T_SOAP_DOCUMENT sourceDocument) throws WebServiceException {
        return ((OCR)this.getPort()).execute((OperationData)this.getOperationData(), sourceDocument.getSourceDataHandler(), sourceDocument.isFileSource() || sourceDocument.getSource() == null ? null : sourceDocument.getSource().toString());
    }

    @Override
    @NotNull
    public OcrType getOperationParameters() {
        return ((OperationData)this.getOperationData()).getOcr();
    }

    @Override
    public void setOperationParameters(@Nullable OcrType operation) {
        if (operation != null) {
            ((OperationData)this.getOperationData()).setOcr(operation);
        }
    }

    @Override
    @NotNull
    protected OCR provideWebServicePort() throws ResultException {
        return (OCR)Service.create((URL)this.getWsdlDocumentLocation(), (QName)this.getQName()).getPort(new QName(WebServiceType.OCR.getSoapNamespaceURI(), WebServiceType.OCR.getSoapLocalPartPort()), OCR.class, new WebServiceFeature[]{this.getMTOMFeature()});
    }

    @Override
    @NotNull
    protected OperationData initOperation() {
        OperationData operationData = new OperationData();
        operationData.setBilling(new BillingType());
        operationData.setPassword(new PdfPasswordType());
        operationData.setSettings(new SettingsType());
        operationData.setOcr(new OcrType());
        return operationData;
    }
}

