/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.webservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.webpdf.wsclient.session.Session;
import net.webpdf.wsclient.session.documents.Document;
import net.webpdf.wsclient.webservice.WebService;
import net.webpdf.wsclient.webservice.WebServiceType;
import org.apache.hc.core5.http.NameValuePair;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWebService<T_SESSION extends Session, T_OPERATION_DATA, T_OPERATION_PARAMETER, T_DOCUMENT extends Document, T_BILLING, T_PASSWORD, T_SETTINGS>
implements WebService<T_SESSION, T_OPERATION_PARAMETER, T_DOCUMENT, T_BILLING, T_PASSWORD, T_SETTINGS> {
    @NotNull
    private final WebServiceType webServiceType;
    @NotNull
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    @NotNull
    private final T_SESSION session;
    @NotNull
    private final T_OPERATION_DATA operationData;
    @NotNull
    private final List<NameValuePair> additionalParameter = new ArrayList<NameValuePair>();

    public AbstractWebService(@NotNull WebServiceType webServiceType, @NotNull T_SESSION session) {
        this.session = session;
        this.webServiceType = webServiceType;
        this.operationData = this.initOperation();
    }

    @Override
    @NotNull
    public T_SESSION getSession() {
        return this.session;
    }

    @NotNull
    protected T_OPERATION_DATA getOperationData() {
        return this.operationData;
    }

    @NotNull
    protected WebServiceType getWebServiceType() {
        return this.webServiceType;
    }

    @NotNull
    protected Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @NotNull
    protected abstract T_OPERATION_DATA initOperation();

    @Override
    @NotNull
    public List<NameValuePair> getAdditionalParameter() {
        return this.additionalParameter;
    }
}

