/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session.soap.documents.datasource;

import jakarta.activation.DataSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.webpdf.wsclient.exception.ClientResultException;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.ResultException;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

public class BinaryDataSource
implements DataSource,
AutoCloseable {
    @NotNull
    private final File tempFile = File.createTempFile("SOAPClient", null);

    public BinaryDataSource(@NotNull InputStream inputStream) throws IOException {
        this.tempFile.deleteOnExit();
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)this.tempFile);
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.tempFile.toPath(), new OpenOption[0]);
    }

    @NotNull
    public OutputStream getOutputStream() throws IOException {
        return Files.newOutputStream(this.tempFile.toPath(), new OpenOption[0]);
    }

    @NotNull
    public String getContentType() {
        return "application/octet-stream";
    }

    @NotNull
    public String getName() {
        return "";
    }

    @Override
    public void close() throws ResultException {
        if (!this.tempFile.delete()) {
            throw new ClientResultException(Error.FAILED_TO_CLOSE_DATA_SOURCE);
        }
    }
}

