/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session.soap;

import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.session.AbstractSession;
import net.webpdf.wsclient.session.auth.AuthProvider;
import net.webpdf.wsclient.session.connection.SessionContext;
import net.webpdf.wsclient.session.soap.ClientProxySelector;
import net.webpdf.wsclient.session.soap.SoapSession;
import net.webpdf.wsclient.session.soap.documents.SoapDocument;
import net.webpdf.wsclient.webservice.WebServiceProtocol;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSoapSession<T_SOAP_DOCUMENT extends SoapDocument>
extends AbstractSession
implements SoapSession<T_SOAP_DOCUMENT> {
    @NotNull
    private final AtomicBoolean useLocalWsdl = new AtomicBoolean(true);
    @NotNull
    private final AtomicReference<ClientProxySelector> proxySelector = new AtomicReference();

    public AbstractSoapSession(@NotNull SessionContext serverContext, @NotNull AuthProvider authProvider) throws ResultException {
        super(WebServiceProtocol.SOAP, serverContext, authProvider);
        if (this.getSessionContext().getProxy() != null) {
            if (this.proxySelector.get() != null) {
                this.proxySelector.get().close();
                this.proxySelector.set(null);
            }
            this.proxySelector.set(new ClientProxySelector(new URI[]{this.getURI("")}, this.getSessionContext().getProxy().getHost()));
        }
    }

    @Override
    public boolean isUseLocalWsdl() {
        return this.useLocalWsdl.get();
    }

    @Override
    public void setUseLocalWsdl(boolean useLocalWsdl) {
        this.useLocalWsdl.set(useLocalWsdl);
    }

    @Override
    public void close() {
        if (this.proxySelector.get() != null) {
            this.proxySelector.get().close();
        }
    }
}

