/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session.rest.documents;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.openapi.DocumentFile;
import net.webpdf.wsclient.openapi.DocumentFileCompress;
import net.webpdf.wsclient.openapi.DocumentFileExtract;
import net.webpdf.wsclient.openapi.DocumentInfo;
import net.webpdf.wsclient.openapi.DocumentInfoType;
import net.webpdf.wsclient.schema.beans.HistoryEntry;
import net.webpdf.wsclient.schema.operation.PdfPasswordType;
import net.webpdf.wsclient.session.rest.RestSession;
import net.webpdf.wsclient.session.rest.documents.RestDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DocumentManager<T_REST_DOCUMENT extends RestDocument> {
    @NotNull
    public RestSession<T_REST_DOCUMENT> getSession();

    @NotNull
    public T_REST_DOCUMENT synchronizeDocument(@NotNull DocumentFile var1) throws ResultException;

    @NotNull
    public List<T_REST_DOCUMENT> synchronize(@NotNull List<DocumentFile> var1) throws ResultException;

    @NotNull
    public List<T_REST_DOCUMENT> synchronize() throws ResultException;

    @NotNull
    public String getDocumentID(@NotNull DocumentFile var1) throws ResultException;

    @NotNull
    public T_REST_DOCUMENT getDocument(@NotNull String var1) throws ResultException;

    @NotNull
    public List<T_REST_DOCUMENT> getDocuments();

    public boolean containsDocument(@NotNull String var1);

    public void downloadDocument(@NotNull String var1, @NotNull OutputStream var2) throws ResultException;

    @Deprecated
    public void downloadDocument(@Nullable RestDocument var1, @NotNull OutputStream var2) throws ResultException;

    @NotNull
    public T_REST_DOCUMENT uploadDocument(@NotNull File var1) throws ResultException;

    @NotNull
    public T_REST_DOCUMENT uploadDocument(@NotNull InputStream var1, @NotNull String var2) throws ResultException;

    public void deleteDocument(@NotNull String var1) throws ResultException;

    @NotNull
    public T_REST_DOCUMENT renameDocument(@NotNull String var1, @NotNull String var2) throws ResultException;

    public boolean isDocumentHistoryActive();

    public void setDocumentHistoryActive(boolean var1) throws ResultException;

    @NotNull
    public List<HistoryEntry> getDocumentHistory(@NotNull String var1) throws ResultException;

    @NotNull
    public HistoryEntry getDocumentHistoryEntry(@NotNull String var1, int var2) throws ResultException;

    @Nullable
    public HistoryEntry updateDocumentHistory(@NotNull String var1, @NotNull HistoryEntry var2) throws ResultException;

    @NotNull
    public T_REST_DOCUMENT updateDocumentSecurity(@NotNull String var1, @NotNull PdfPasswordType var2) throws ResultException;

    @NotNull
    public DocumentInfo getDocumentInfo(@NotNull String var1, @NotNull DocumentInfoType var2) throws ResultException;

    @NotNull
    public List<T_REST_DOCUMENT> extractDocument(@NotNull String var1, @NotNull DocumentFileExtract var2) throws ResultException;

    public void extractArchiveFile(@NotNull String var1, @NotNull String var2, @NotNull OutputStream var3) throws ResultException;

    @NotNull
    public T_REST_DOCUMENT compressDocuments(@NotNull DocumentFileCompress var1) throws ResultException;

    @NotNull
    public T_REST_DOCUMENT updateDocument(@NotNull String var1, @NotNull InputStream var2) throws ResultException;
}

