/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session.auth.material.token;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.time.Instant;
import net.webpdf.wsclient.session.auth.material.token.JWTToken;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"expiresIn", "token", "refreshToken"})
public class SessionToken
implements Serializable,
JWTToken {
    @JsonProperty(value="token")
    @NotNull
    private String token = "";
    @JsonProperty(value="refreshToken")
    @NotNull
    private String refreshToken = "";
    @JsonProperty(value="expiresIn")
    private long expiresIn = -1L;
    @NotNull
    private Instant expiration = Instant.now();

    @JsonCreator
    public SessionToken(@JsonProperty(value="token") @NotNull String accessToken, @JsonProperty(value="refreshToken") @NotNull String refreshToken, @JsonProperty(value="expiresIn") long expiresIn) {
        this.expiration = this.expiration.plusSeconds(expiresIn);
        this.token = accessToken;
        this.refreshToken = refreshToken;
        this.expiresIn = expiresIn;
    }

    public SessionToken() {
    }

    @Override
    @NotNull
    public String getToken() {
        return this.token;
    }

    public void refresh() {
        this.token = this.refreshToken;
    }

    @NotNull
    public Instant getExpiration() {
        return this.expiration;
    }

    public boolean isExpired(int skewTime) {
        return this.getExpiration().isBefore(Instant.now().plusSeconds(skewTime));
    }
}

