/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="When these settings are present, the server sends a ping to the configured LDAP server to keep the connection alive.")
@JsonPropertyOrder(value={"enabled", "sendInterval"})
@JsonTypeName(value="ServerConfig_UserKeepAliveLdap")
public class ServerConfigUserKeepAliveLdap {
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = false;
    public static final String JSON_PROPERTY_SEND_INTERVAL = "sendInterval";
    private Integer sendInterval = 300;

    public ServerConfigUserKeepAliveLdap enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Schema(name="When set to true the server sends a ping to the configured LDAP server to keep the connection alive.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public ServerConfigUserKeepAliveLdap sendInterval(Integer sendInterval) {
        this.sendInterval = sendInterval;
        return this;
    }

    @Schema(name="The sending interval in seconds at which the ping is sent.")
    @JsonProperty(value="sendInterval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getSendInterval() {
        return this.sendInterval;
    }

    @JsonProperty(value="sendInterval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSendInterval(Integer sendInterval) {
        this.sendInterval = sendInterval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfigUserKeepAliveLdap serverConfigUserKeepAliveLdap = (ServerConfigUserKeepAliveLdap)o;
        return Objects.equals(this.enabled, serverConfigUserKeepAliveLdap.enabled) && Objects.equals(this.sendInterval, serverConfigUserKeepAliveLdap.sendInterval);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.sendInterval);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerConfigUserKeepAliveLdap {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    sendInterval: ").append(this.toIndentedString(this.sendInterval)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

