/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines a relational user database as a user source.")
@JsonPropertyOrder(value={"connectionName", "connectionPassword", "connectionURL", "digest", "driverName", "roleNameCol", "userCredCol", "userNameCol", "userRoleTable", "userTable"})
@JsonTypeName(value="ServerConfig_UserDb")
public class ServerConfigUserDb {
    public static final String JSON_PROPERTY_CONNECTION_NAME = "connectionName";
    private String connectionName = "";
    public static final String JSON_PROPERTY_CONNECTION_PASSWORD = "connectionPassword";
    private String connectionPassword = "";
    public static final String JSON_PROPERTY_CONNECTION_U_R_L = "connectionURL";
    private String connectionURL = "";
    public static final String JSON_PROPERTY_DIGEST = "digest";
    private String digest = "";
    public static final String JSON_PROPERTY_DRIVER_NAME = "driverName";
    private String driverName = "";
    public static final String JSON_PROPERTY_ROLE_NAME_COL = "roleNameCol";
    private String roleNameCol = "role_name";
    public static final String JSON_PROPERTY_USER_CRED_COL = "userCredCol";
    private String userCredCol = "user_pass";
    public static final String JSON_PROPERTY_USER_NAME_COL = "userNameCol";
    private String userNameCol = "user_name";
    public static final String JSON_PROPERTY_USER_ROLE_TABLE = "userRoleTable";
    private String userRoleTable = "user_roles";
    public static final String JSON_PROPERTY_USER_TABLE = "userTable";
    private String userTable = "users";

    public ServerConfigUserDb connectionName(String connectionName) {
        this.connectionName = connectionName;
        return this;
    }

    @Schema(name="The name of the database user to access the database for.")
    @JsonProperty(value="connectionName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getConnectionName() {
        return this.connectionName;
    }

    @JsonProperty(value="connectionName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public ServerConfigUserDb connectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
        return this;
    }

    @Schema(name="The password of the database user to access the database with.")
    @JsonProperty(value="connectionPassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    @JsonProperty(value="connectionPassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }

    public ServerConfigUserDb connectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
        return this;
    }

    @Schema(name="The URL of the database. (e.g. \"jdbc:mysql://localhost:3306/webpdf\".)")
    @JsonProperty(value="connectionURL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getConnectionURL() {
        return this.connectionURL;
    }

    @JsonProperty(value="connectionURL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public ServerConfigUserDb digest(String digest) {
        this.digest = digest;
        return this;
    }

    @Schema(name="This field currently is unused.")
    @JsonProperty(value="digest")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getDigest() {
        return this.digest;
    }

    @JsonProperty(value="digest")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDigest(String digest) {
        this.digest = digest;
    }

    public ServerConfigUserDb driverName(String driverName) {
        this.driverName = driverName;
        return this;
    }

    @Schema(name="The name of the driver (path of the java class) to use for database access. (e.g. \"com.mysql.jdbc.Driver\".)")
    @JsonProperty(value="driverName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getDriverName() {
        return this.driverName;
    }

    @JsonProperty(value="driverName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public ServerConfigUserDb roleNameCol(String roleNameCol) {
        this.roleNameCol = roleNameCol;
        return this;
    }

    @Schema(name="The name of the column containing the user's role.")
    @JsonProperty(value="roleNameCol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getRoleNameCol() {
        return this.roleNameCol;
    }

    @JsonProperty(value="roleNameCol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoleNameCol(String roleNameCol) {
        this.roleNameCol = roleNameCol;
    }

    public ServerConfigUserDb userCredCol(String userCredCol) {
        this.userCredCol = userCredCol;
        return this;
    }

    @Schema(name="The name of the column containing the user's credentials.")
    @JsonProperty(value="userCredCol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUserCredCol() {
        return this.userCredCol;
    }

    @JsonProperty(value="userCredCol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserCredCol(String userCredCol) {
        this.userCredCol = userCredCol;
    }

    public ServerConfigUserDb userNameCol(String userNameCol) {
        this.userNameCol = userNameCol;
        return this;
    }

    @Schema(name="The name of the column containing the user's name.")
    @JsonProperty(value="userNameCol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUserNameCol() {
        return this.userNameCol;
    }

    @JsonProperty(value="userNameCol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserNameCol(String userNameCol) {
        this.userNameCol = userNameCol;
    }

    public ServerConfigUserDb userRoleTable(String userRoleTable) {
        this.userRoleTable = userRoleTable;
        return this;
    }

    @Schema(name="The name of the table that defines the available user roles.")
    @JsonProperty(value="userRoleTable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUserRoleTable() {
        return this.userRoleTable;
    }

    @JsonProperty(value="userRoleTable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserRoleTable(String userRoleTable) {
        this.userRoleTable = userRoleTable;
    }

    public ServerConfigUserDb userTable(String userTable) {
        this.userTable = userTable;
        return this;
    }

    @Schema(name="The name of the database table, that lists the server's users.")
    @JsonProperty(value="userTable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUserTable() {
        return this.userTable;
    }

    @JsonProperty(value="userTable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserTable(String userTable) {
        this.userTable = userTable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfigUserDb serverConfigUserDb = (ServerConfigUserDb)o;
        return Objects.equals(this.connectionName, serverConfigUserDb.connectionName) && Objects.equals(this.connectionPassword, serverConfigUserDb.connectionPassword) && Objects.equals(this.connectionURL, serverConfigUserDb.connectionURL) && Objects.equals(this.digest, serverConfigUserDb.digest) && Objects.equals(this.driverName, serverConfigUserDb.driverName) && Objects.equals(this.roleNameCol, serverConfigUserDb.roleNameCol) && Objects.equals(this.userCredCol, serverConfigUserDb.userCredCol) && Objects.equals(this.userNameCol, serverConfigUserDb.userNameCol) && Objects.equals(this.userRoleTable, serverConfigUserDb.userRoleTable) && Objects.equals(this.userTable, serverConfigUserDb.userTable);
    }

    public int hashCode() {
        return Objects.hash(this.connectionName, this.connectionPassword, this.connectionURL, this.digest, this.driverName, this.roleNameCol, this.userCredCol, this.userNameCol, this.userRoleTable, this.userTable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerConfigUserDb {\n");
        sb.append("    connectionName: ").append(this.toIndentedString(this.connectionName)).append("\n");
        sb.append("    connectionPassword: ").append(this.toIndentedString(this.connectionPassword)).append("\n");
        sb.append("    connectionURL: ").append(this.toIndentedString(this.connectionURL)).append("\n");
        sb.append("    digest: ").append(this.toIndentedString(this.digest)).append("\n");
        sb.append("    driverName: ").append(this.toIndentedString(this.driverName)).append("\n");
        sb.append("    roleNameCol: ").append(this.toIndentedString(this.roleNameCol)).append("\n");
        sb.append("    userCredCol: ").append(this.toIndentedString(this.userCredCol)).append("\n");
        sb.append("    userNameCol: ").append(this.toIndentedString(this.userNameCol)).append("\n");
        sb.append("    userRoleTable: ").append(this.toIndentedString(this.userRoleTable)).append("\n");
        sb.append("    userTable: ").append(this.toIndentedString(this.userTable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

