/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines the restrictions and limits that apply when using the REST API and user sessions on the server.")
@JsonPropertyOrder(value={"diskSpaceLimit", "diskSpaceLimitUser", "maxFiles", "maxFilesUser", "uploadLimit", "uploadLimitUser"})
@JsonTypeName(value="ServerConfig_SessionLimits")
public class ServerConfigSessionLimits {
    public static final String JSON_PROPERTY_DISK_SPACE_LIMIT = "diskSpaceLimit";
    private Integer diskSpaceLimit = 0;
    public static final String JSON_PROPERTY_DISK_SPACE_LIMIT_USER = "diskSpaceLimitUser";
    private Integer diskSpaceLimitUser = 0;
    public static final String JSON_PROPERTY_MAX_FILES = "maxFiles";
    private Integer maxFiles = 0;
    public static final String JSON_PROPERTY_MAX_FILES_USER = "maxFilesUser";
    private Integer maxFilesUser = 0;
    public static final String JSON_PROPERTY_UPLOAD_LIMIT = "uploadLimit";
    private Integer uploadLimit = 0;
    public static final String JSON_PROPERTY_UPLOAD_LIMIT_USER = "uploadLimitUser";
    private Integer uploadLimitUser = 0;

    public ServerConfigSessionLimits diskSpaceLimit(Integer diskSpaceLimit) {
        this.diskSpaceLimit = diskSpaceLimit;
        return this;
    }

    @Schema(name="Sets the overall global disk space (in bytes) the server may use (set to 0 to disable this limitation).")
    @JsonProperty(value="diskSpaceLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getDiskSpaceLimit() {
        return this.diskSpaceLimit;
    }

    @JsonProperty(value="diskSpaceLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDiskSpaceLimit(Integer diskSpaceLimit) {
        this.diskSpaceLimit = diskSpaceLimit;
    }

    public ServerConfigSessionLimits diskSpaceLimitUser(Integer diskSpaceLimitUser) {
        this.diskSpaceLimitUser = diskSpaceLimitUser;
        return this;
    }

    @Schema(name="Sets the maximum disk space (in bytes) a single user may use (set to 0 to disable this limitation).")
    @JsonProperty(value="diskSpaceLimitUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getDiskSpaceLimitUser() {
        return this.diskSpaceLimitUser;
    }

    @JsonProperty(value="diskSpaceLimitUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDiskSpaceLimitUser(Integer diskSpaceLimitUser) {
        this.diskSpaceLimitUser = diskSpaceLimitUser;
    }

    public ServerConfigSessionLimits maxFiles(Integer maxFiles) {
        this.maxFiles = maxFiles;
        return this;
    }

    @Schema(name="Sets the maximum number of files that may be uploaded to the server (set to 0 to disable this limitation).")
    @JsonProperty(value="maxFiles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getMaxFiles() {
        return this.maxFiles;
    }

    @JsonProperty(value="maxFiles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxFiles(Integer maxFiles) {
        this.maxFiles = maxFiles;
    }

    public ServerConfigSessionLimits maxFilesUser(Integer maxFilesUser) {
        this.maxFilesUser = maxFilesUser;
        return this;
    }

    @Schema(name="Sets the maximum number of files a single user may upload to the server (set to 0 to disable this limitation).")
    @JsonProperty(value="maxFilesUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getMaxFilesUser() {
        return this.maxFilesUser;
    }

    @JsonProperty(value="maxFilesUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxFilesUser(Integer maxFilesUser) {
        this.maxFilesUser = maxFilesUser;
    }

    public ServerConfigSessionLimits uploadLimit(Integer uploadLimit) {
        this.uploadLimit = uploadLimit;
        return this;
    }

    @Schema(name="Sets the maximum size (in bytes) a file uploaded to the server may have (set to 0 to disable this limitation).")
    @JsonProperty(value="uploadLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getUploadLimit() {
        return this.uploadLimit;
    }

    @JsonProperty(value="uploadLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUploadLimit(Integer uploadLimit) {
        this.uploadLimit = uploadLimit;
    }

    public ServerConfigSessionLimits uploadLimitUser(Integer uploadLimitUser) {
        this.uploadLimitUser = uploadLimitUser;
        return this;
    }

    @Schema(name="Sets the maximum size (in bytes) a file uploaded by a single user may have (set to 0 to disable this limitation).")
    @JsonProperty(value="uploadLimitUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getUploadLimitUser() {
        return this.uploadLimitUser;
    }

    @JsonProperty(value="uploadLimitUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUploadLimitUser(Integer uploadLimitUser) {
        this.uploadLimitUser = uploadLimitUser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfigSessionLimits serverConfigSessionLimits = (ServerConfigSessionLimits)o;
        return Objects.equals(this.diskSpaceLimit, serverConfigSessionLimits.diskSpaceLimit) && Objects.equals(this.diskSpaceLimitUser, serverConfigSessionLimits.diskSpaceLimitUser) && Objects.equals(this.maxFiles, serverConfigSessionLimits.maxFiles) && Objects.equals(this.maxFilesUser, serverConfigSessionLimits.maxFilesUser) && Objects.equals(this.uploadLimit, serverConfigSessionLimits.uploadLimit) && Objects.equals(this.uploadLimitUser, serverConfigSessionLimits.uploadLimitUser);
    }

    public int hashCode() {
        return Objects.hash(this.diskSpaceLimit, this.diskSpaceLimitUser, this.maxFiles, this.maxFilesUser, this.uploadLimit, this.uploadLimitUser);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerConfigSessionLimits {\n");
        sb.append("    diskSpaceLimit: ").append(this.toIndentedString(this.diskSpaceLimit)).append("\n");
        sb.append("    diskSpaceLimitUser: ").append(this.toIndentedString(this.diskSpaceLimitUser)).append("\n");
        sb.append("    maxFiles: ").append(this.toIndentedString(this.maxFiles)).append("\n");
        sb.append("    maxFilesUser: ").append(this.toIndentedString(this.maxFilesUser)).append("\n");
        sb.append("    uploadLimit: ").append(this.toIndentedString(this.uploadLimit)).append("\n");
        sb.append("    uploadLimitUser: ").append(this.toIndentedString(this.uploadLimitUser)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

