/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.ServerConfigCiphersSSL;
import net.webpdf.wsclient.openapi.ServerConfigConnectorConfiguration;
import net.webpdf.wsclient.openapi.ServerConfigKeystore;
import net.webpdf.wsclient.openapi.ServerConfigKeystoreSSL;
import net.webpdf.wsclient.openapi.ServerConfigProtocolsSSL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines the settings for a TLS connector.")
@JsonPropertyOrder(value={"ciphers", "clientAuth", "configuration", "keystore", "maxThreads", "protocols", "scheme", "sessionCacheSize", "sessionTimeout", "truststore"})
@JsonTypeName(value="ServerConfig_SSL")
public class ServerConfigSSL {
    public static final String JSON_PROPERTY_CIPHERS = "ciphers";
    private ServerConfigCiphersSSL ciphers;
    public static final String JSON_PROPERTY_CLIENT_AUTH = "clientAuth";
    private Boolean clientAuth = false;
    public static final String JSON_PROPERTY_CONFIGURATION = "configuration";
    private ServerConfigConnectorConfiguration _configuration;
    public static final String JSON_PROPERTY_KEYSTORE = "keystore";
    private ServerConfigKeystoreSSL keystore;
    public static final String JSON_PROPERTY_MAX_THREADS = "maxThreads";
    private Integer maxThreads = 150;
    public static final String JSON_PROPERTY_PROTOCOLS = "protocols";
    private ServerConfigProtocolsSSL protocols;
    public static final String JSON_PROPERTY_SCHEME = "scheme";
    private String scheme = "https";
    public static final String JSON_PROPERTY_SESSION_CACHE_SIZE = "sessionCacheSize";
    private Integer sessionCacheSize = 0;
    public static final String JSON_PROPERTY_SESSION_TIMEOUT = "sessionTimeout";
    private Integer sessionTimeout = 86400;
    public static final String JSON_PROPERTY_TRUSTSTORE = "truststore";
    private ServerConfigKeystore truststore;

    public ServerConfigSSL ciphers(ServerConfigCiphersSSL ciphers) {
        this.ciphers = ciphers;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="ciphers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ServerConfigCiphersSSL getCiphers() {
        return this.ciphers;
    }

    @JsonProperty(value="ciphers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCiphers(ServerConfigCiphersSSL ciphers) {
        this.ciphers = ciphers;
    }

    public ServerConfigSSL clientAuth(Boolean clientAuth) {
        this.clientAuth = clientAuth;
        return this;
    }

    @Schema(name="Whether a client must provide a valid certificate before being accepted by the connector.")
    @JsonProperty(value="clientAuth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getClientAuth() {
        return this.clientAuth;
    }

    @JsonProperty(value="clientAuth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientAuth(Boolean clientAuth) {
        this.clientAuth = clientAuth;
    }

    public ServerConfigSSL _configuration(ServerConfigConnectorConfiguration _configuration) {
        this._configuration = _configuration;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ServerConfigConnectorConfiguration getConfiguration() {
        return this._configuration;
    }

    @JsonProperty(value="configuration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfiguration(ServerConfigConnectorConfiguration _configuration) {
        this._configuration = _configuration;
    }

    public ServerConfigSSL keystore(ServerConfigKeystoreSSL keystore) {
        this.keystore = keystore;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="keystore")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public ServerConfigKeystoreSSL getKeystore() {
        return this.keystore;
    }

    @JsonProperty(value="keystore")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKeystore(ServerConfigKeystoreSSL keystore) {
        this.keystore = keystore;
    }

    public ServerConfigSSL maxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    @Schema(name="The maximum number of request processing threads created by this connector.")
    @JsonProperty(value="maxThreads")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    @JsonProperty(value="maxThreads")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    public ServerConfigSSL protocols(ServerConfigProtocolsSSL protocols) {
        this.protocols = protocols;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="protocols")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public ServerConfigProtocolsSSL getProtocols() {
        return this.protocols;
    }

    @JsonProperty(value="protocols")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProtocols(ServerConfigProtocolsSSL protocols) {
        this.protocols = protocols;
    }

    public ServerConfigSSL scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    @Schema(name="The TLS connection scheme. (e.g. \"https\")")
    @JsonProperty(value="scheme")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getScheme() {
        return this.scheme;
    }

    @JsonProperty(value="scheme")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public ServerConfigSSL sessionCacheSize(Integer sessionCacheSize) {
        this.sessionCacheSize = sessionCacheSize;
        return this;
    }

    @Schema(name="The number of SSL sessions to maintain in the session cache.")
    @JsonProperty(value="sessionCacheSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    @JsonProperty(value="sessionCacheSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSessionCacheSize(Integer sessionCacheSize) {
        this.sessionCacheSize = sessionCacheSize;
    }

    public ServerConfigSSL sessionTimeout(Integer sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    @Schema(name="The time in seconds before a session is encountering its timeout.")
    @JsonProperty(value="sessionTimeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getSessionTimeout() {
        return this.sessionTimeout;
    }

    @JsonProperty(value="sessionTimeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSessionTimeout(Integer sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public ServerConfigSSL truststore(ServerConfigKeystore truststore) {
        this.truststore = truststore;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="truststore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ServerConfigKeystore getTruststore() {
        return this.truststore;
    }

    @JsonProperty(value="truststore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTruststore(ServerConfigKeystore truststore) {
        this.truststore = truststore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfigSSL serverConfigSSL = (ServerConfigSSL)o;
        return Objects.equals(this.ciphers, serverConfigSSL.ciphers) && Objects.equals(this.clientAuth, serverConfigSSL.clientAuth) && Objects.equals(this._configuration, serverConfigSSL._configuration) && Objects.equals(this.keystore, serverConfigSSL.keystore) && Objects.equals(this.maxThreads, serverConfigSSL.maxThreads) && Objects.equals(this.protocols, serverConfigSSL.protocols) && Objects.equals(this.scheme, serverConfigSSL.scheme) && Objects.equals(this.sessionCacheSize, serverConfigSSL.sessionCacheSize) && Objects.equals(this.sessionTimeout, serverConfigSSL.sessionTimeout) && Objects.equals(this.truststore, serverConfigSSL.truststore);
    }

    public int hashCode() {
        return Objects.hash(this.ciphers, this.clientAuth, this._configuration, this.keystore, this.maxThreads, this.protocols, this.scheme, this.sessionCacheSize, this.sessionTimeout, this.truststore);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerConfigSSL {\n");
        sb.append("    ciphers: ").append(this.toIndentedString(this.ciphers)).append("\n");
        sb.append("    clientAuth: ").append(this.toIndentedString(this.clientAuth)).append("\n");
        sb.append("    _configuration: ").append(this.toIndentedString(this._configuration)).append("\n");
        sb.append("    keystore: ").append(this.toIndentedString(this.keystore)).append("\n");
        sb.append("    maxThreads: ").append(this.toIndentedString(this.maxThreads)).append("\n");
        sb.append("    protocols: ").append(this.toIndentedString(this.protocols)).append("\n");
        sb.append("    scheme: ").append(this.toIndentedString(this.scheme)).append("\n");
        sb.append("    sessionCacheSize: ").append(this.toIndentedString(this.sessionCacheSize)).append("\n");
        sb.append("    sessionTimeout: ").append(this.toIndentedString(this.sessionTimeout)).append("\n");
        sb.append("    truststore: ").append(this.toIndentedString(this.truststore)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

