/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.ServerConfigLocalAuthRest;
import net.webpdf.wsclient.openapi.ServerConfigLocalAuthSoap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines the local authorization provider that authenticates users and provides authorization tokens for API access.")
@JsonPropertyOrder(value={"enabled", "rest", "soap"})
@JsonTypeName(value="ServerConfig_LocalAuth")
public class ServerConfigLocalAuth {
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = true;
    public static final String JSON_PROPERTY_REST = "rest";
    private ServerConfigLocalAuthRest rest;
    public static final String JSON_PROPERTY_SOAP = "soap";
    private ServerConfigLocalAuthSoap soap;

    public ServerConfigLocalAuth enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Schema(name="If enabled, the local authorization provider is available to authenticate the user login and provide tokens for accessing the server API. If disabled, only external (e.g., OAuth) access tokens are allowed for API calls.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public ServerConfigLocalAuth rest(ServerConfigLocalAuthRest rest) {
        this.rest = rest;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="rest")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public ServerConfigLocalAuthRest getRest() {
        return this.rest;
    }

    @JsonProperty(value="rest")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRest(ServerConfigLocalAuthRest rest) {
        this.rest = rest;
    }

    public ServerConfigLocalAuth soap(ServerConfigLocalAuthSoap soap) {
        this.soap = soap;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="soap")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public ServerConfigLocalAuthSoap getSoap() {
        return this.soap;
    }

    @JsonProperty(value="soap")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSoap(ServerConfigLocalAuthSoap soap) {
        this.soap = soap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfigLocalAuth serverConfigLocalAuth = (ServerConfigLocalAuth)o;
        return Objects.equals(this.enabled, serverConfigLocalAuth.enabled) && Objects.equals(this.rest, serverConfigLocalAuth.rest) && Objects.equals(this.soap, serverConfigLocalAuth.soap);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.rest, this.soap);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerConfigLocalAuth {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    rest: ").append(this.toIndentedString(this.rest)).append("\n");
        sb.append("    soap: ").append(this.toIndentedString(this.soap)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

