/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="A `valve` element represents a component to insert into the request processing pipeline of the underlying Tomcat server. (See: https://tomcat.apache.org/tomcat-10.1-doc/config/valve.html for further information.)")
@JsonPropertyOrder(value={"className", "otherAttributes"})
@JsonTypeName(value="ServerConfig_HostValve")
public class ServerConfigHostValve {
    public static final String JSON_PROPERTY_CLASS_NAME = "className";
    private String className = "";
    public static final String JSON_PROPERTY_OTHER_ATTRIBUTES = "otherAttributes";
    private Map<String, String> otherAttributes = null;

    public ServerConfigHostValve className(String className) {
        this.className = className;
        return this;
    }

    @Schema(name="The Java class name of the valve implementation to use.")
    @JsonProperty(value="className")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getClassName() {
        return this.className;
    }

    @JsonProperty(value="className")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClassName(String className) {
        this.className = className;
    }

    public ServerConfigHostValve otherAttributes(Map<String, String> otherAttributes) {
        this.otherAttributes = otherAttributes;
        return this;
    }

    public ServerConfigHostValve putotherAttributesItem(String key, String otherAttributesItem) {
        if (this.otherAttributes == null) {
            this.otherAttributes = new HashMap<String, String>();
        }
        this.otherAttributes.put(key, otherAttributesItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="otherAttributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Map<String, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    @JsonProperty(value="otherAttributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOtherAttributes(Map<String, String> otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfigHostValve serverConfigHostValve = (ServerConfigHostValve)o;
        return Objects.equals(this.className, serverConfigHostValve.className) && Objects.equals(this.otherAttributes, serverConfigHostValve.otherAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.otherAttributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerConfigHostValve {\n");
        sb.append("    className: ").append(this.toIndentedString(this.className)).append("\n");
        sb.append("    otherAttributes: ").append(this.toIndentedString(this.otherAttributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

