/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="The `csp` element allows you to set a content security policy (https://developer.mozilla.org/en-US/docs/Web/HTTP/CSP) for the server portal page.")
@JsonPropertyOrder(value={"enabled", "headerValue"})
@JsonTypeName(value="ServerConfig_HostCsp")
public class ServerConfigHostCsp {
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = false;
    public static final String JSON_PROPERTY_HEADER_VALUE = "headerValue";
    private String headerValue = "";

    public ServerConfigHostCsp enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Schema(name="When set to true, the CSP is activated. The HTTP header \"Content-Security-Policy\" is added, and a \"nonce\" is added to the required resources.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public ServerConfigHostCsp headerValue(String headerValue) {
        this.headerValue = headerValue;
        return this;
    }

    @Schema(name="Defines the value for the HTTP header `Content-Security-Policy`. Use `${nonce}` to insert a nonce value from the server for the entry `'nonce-...'`.")
    @JsonProperty(value="headerValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getHeaderValue() {
        return this.headerValue;
    }

    @JsonProperty(value="headerValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeaderValue(String headerValue) {
        this.headerValue = headerValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfigHostCsp serverConfigHostCsp = (ServerConfigHostCsp)o;
        return Objects.equals(this.enabled, serverConfigHostCsp.enabled) && Objects.equals(this.headerValue, serverConfigHostCsp.headerValue);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.headerValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerConfigHostCsp {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    headerValue: ").append(this.toIndentedString(this.headerValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

