/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Selects encryption algorithms (ciphers) used by the TLS connector.")
@JsonPropertyOrder(value={"cipher", "forceOrder"})
@JsonTypeName(value="ServerConfig_CiphersSSL")
public class ServerConfigCiphersSSL {
    public static final String JSON_PROPERTY_CIPHER = "cipher";
    private List<String> cipher = null;
    public static final String JSON_PROPERTY_FORCE_ORDER = "forceOrder";
    private Boolean forceOrder = false;

    public ServerConfigCiphersSSL cipher(List<String> cipher) {
        this.cipher = cipher;
        return this;
    }

    public ServerConfigCiphersSSL addCipherItem(String cipherItem) {
        if (this.cipher == null) {
            this.cipher = new ArrayList<String>();
        }
        this.cipher.add(cipherItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="cipher")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<String> getCipher() {
        return this.cipher;
    }

    @JsonProperty(value="cipher")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCipher(List<String> cipher) {
        this.cipher = cipher;
    }

    public ServerConfigCiphersSSL forceOrder(Boolean forceOrder) {
        this.forceOrder = forceOrder;
        return this;
    }

    @Schema(name="When set to true, this forces the client to honor the TLS connector's cipher preference order. Otherwise, the client can select any cipher from the list itself.")
    @JsonProperty(value="forceOrder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getForceOrder() {
        return this.forceOrder;
    }

    @JsonProperty(value="forceOrder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setForceOrder(Boolean forceOrder) {
        this.forceOrder = forceOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfigCiphersSSL serverConfigCiphersSSL = (ServerConfigCiphersSSL)o;
        return Objects.equals(this.cipher, serverConfigCiphersSSL.cipher) && Objects.equals(this.forceOrder, serverConfigCiphersSSL.forceOrder);
    }

    public int hashCode() {
        return Objects.hash(this.cipher, this.forceOrder);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerConfigCiphersSSL {\n");
        sb.append("    cipher: ").append(this.toIndentedString(this.cipher)).append("\n");
        sb.append("    forceOrder: ").append(this.toIndentedString(this.forceOrder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

