/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Provides information about the (file) resources used in the portal page user interface.")
@JsonPropertyOrder(value={"backgroundFileName", "logoFileName", "themeFileName"})
@JsonTypeName(value="Portal_UserInterfaceResources")
public class PortalUserInterfaceResources {
    public static final String JSON_PROPERTY_BACKGROUND_FILE_NAME = "backgroundFileName";
    private String backgroundFileName = "";
    public static final String JSON_PROPERTY_LOGO_FILE_NAME = "logoFileName";
    private String logoFileName = "";
    public static final String JSON_PROPERTY_THEME_FILE_NAME = "themeFileName";
    private String themeFileName = "";

    public PortalUserInterfaceResources backgroundFileName(String backgroundFileName) {
        this.backgroundFileName = backgroundFileName;
        return this;
    }

    @Schema(name="The file name used for the background file in the portal. If it is empty, the default background is used, otherwise a custom background was uploaded and saved under the specified name.")
    @JsonProperty(value="backgroundFileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getBackgroundFileName() {
        return this.backgroundFileName;
    }

    @JsonProperty(value="backgroundFileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBackgroundFileName(String backgroundFileName) {
        this.backgroundFileName = backgroundFileName;
    }

    public PortalUserInterfaceResources logoFileName(String logoFileName) {
        this.logoFileName = logoFileName;
        return this;
    }

    @Schema(name="The file name used for the logo file in the portal. If it is empty, the default logo is used, otherwise a custom logo was uploaded and saved under the specified name.")
    @JsonProperty(value="logoFileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getLogoFileName() {
        return this.logoFileName;
    }

    @JsonProperty(value="logoFileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogoFileName(String logoFileName) {
        this.logoFileName = logoFileName;
    }

    public PortalUserInterfaceResources themeFileName(String themeFileName) {
        this.themeFileName = themeFileName;
        return this;
    }

    @Schema(name="The file name used for the CSS file to customize the theme in the portal. If it is empty, no customized theme is used, otherwise a custom CSS file was uploaded and saved under the specified name.")
    @JsonProperty(value="themeFileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getThemeFileName() {
        return this.themeFileName;
    }

    @JsonProperty(value="themeFileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThemeFileName(String themeFileName) {
        this.themeFileName = themeFileName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortalUserInterfaceResources portalUserInterfaceResources = (PortalUserInterfaceResources)o;
        return Objects.equals(this.backgroundFileName, portalUserInterfaceResources.backgroundFileName) && Objects.equals(this.logoFileName, portalUserInterfaceResources.logoFileName) && Objects.equals(this.themeFileName, portalUserInterfaceResources.themeFileName);
    }

    public int hashCode() {
        return Objects.hash(this.backgroundFileName, this.logoFileName, this.themeFileName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PortalUserInterfaceResources {\n");
        sb.append("    backgroundFileName: ").append(this.toIndentedString(this.backgroundFileName)).append("\n");
        sb.append("    logoFileName: ").append(this.toIndentedString(this.logoFileName)).append("\n");
        sb.append("    themeFileName: ").append(this.toIndentedString(this.themeFileName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

