/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="ZUGFeRD file (XML) in \"Base64 encoded\" format. The ZUGFeRD XSD schema will be used to validate the file before embedding. If it is not valid, the operation will be aborted.")
@JsonPropertyOrder(value={"source", "uri", "value", "version"})
@JsonTypeName(value="Operation_ZugferdFileData")
public class OperationZugferdFileData {
    public static final String JSON_PROPERTY_SOURCE = "source";
    private SourceEnum source = SourceEnum.VALUE;
    public static final String JSON_PROPERTY_URI = "uri";
    private String uri = "";
    public static final String JSON_PROPERTY_VALUE = "value";
    private byte[] value;
    public static final String JSON_PROPERTY_VERSION = "version";
    private VersionEnum version = VersionEnum.V10_COMFORT;

    public OperationZugferdFileData source(SourceEnum source) {
        this.source = source;
        return this;
    }

    @Schema(name="Selects the data source for the hereby expressed resource. Possible values are:  *   value = The element's value shall contain the BASE64 encoded data. *   uri = The data shall be located at the given uri.")
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public SourceEnum getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSource(SourceEnum source) {
        this.source = source;
    }

    public OperationZugferdFileData uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Schema(name="The uri the data shall be located at. (This shall only have effect, if the \"source\" is \"uri\".)")
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUri() {
        return this.uri;
    }

    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUri(String uri) {
        this.uri = uri;
    }

    public OperationZugferdFileData value(byte[] value) {
        this.value = value;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public byte[] getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(byte[] value) {
        this.value = value;
    }

    public OperationZugferdFileData version(VersionEnum version) {
        this.version = version;
        return this;
    }

    @Schema(name="Used to define the version of the ZUGFeRD XML file that should be embedded with \"xmlFile\". Versions from 1.0 to 2.3 are supported. Only the \"Comfort\" profile is available for version 1.0. Meanwhile, the \"Minimum\", \"Basic WL\", \"Basic\", \"EN16931\" (Comfort), and \"Extended\" profiles are supported for version 2.0.  **Note:** Since version 2.x, the referenced profile \"XRECHNUNG\" is additionally available. This profile has been included specifically to include invoices for Germany, based on and under the sole responsibility of KoSIT, Germany's central coordination agency for IT's e-invoice CIUS \"XRechnung\". It is defined as the Standard for electronic invoices issued to public administrations, and essentially adds specific business rules to EN 16931 in order to comply with national laws and regulations.  **Note:** Since version 2.1.1 ZUGFeRD and Factur-X are technically identical, and both formats use Factur-X as common identification.  List of versions with the corresponding profiles:  *   v10Comfort *   v20Minimum *   v20BasicWL *   v20Basic *   v20EN16931 *   v20Extended *   v21Minimum *   v21BasicWL *   v21Basic *   v21EN16931 *   v21Extended *   v21XRechnung *   v22Minimum *   v22BasicWL *   v22Basic *   v22EN16931 *   v22Extended *   v22XRechnung *   v23Minimum *   v23BasicWL *   v23Basic *   v23EN16931 *   v23Extended *   v23XRechnung")
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public VersionEnum getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(VersionEnum version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationZugferdFileData operationZugferdFileData = (OperationZugferdFileData)o;
        return Objects.equals((Object)this.source, (Object)operationZugferdFileData.source) && Objects.equals(this.uri, operationZugferdFileData.uri) && Arrays.equals(this.value, operationZugferdFileData.value) && Objects.equals((Object)this.version, (Object)operationZugferdFileData.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.uri, Arrays.hashCode(this.value), this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationZugferdFileData {\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    version: ").append(this.toIndentedString((Object)this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum VersionEnum {
        V10_COMFORT(String.valueOf("v10Comfort")),
        V20_MINIMUM(String.valueOf("v20Minimum")),
        V20_BASIC_WL(String.valueOf("v20BasicWL")),
        V20_BASIC(String.valueOf("v20Basic")),
        V20_EN16931(String.valueOf("v20EN16931")),
        V20_EXTENDED(String.valueOf("v20Extended")),
        V21_MINIMUM(String.valueOf("v21Minimum")),
        V21_BASIC_WL(String.valueOf("v21BasicWL")),
        V21_BASIC(String.valueOf("v21Basic")),
        V21_EN16931(String.valueOf("v21EN16931")),
        V21_EXTENDED(String.valueOf("v21Extended")),
        V21_X_RECHNUNG(String.valueOf("v21XRechnung")),
        V22_MINIMUM(String.valueOf("v22Minimum")),
        V22_BASIC_WL(String.valueOf("v22BasicWL")),
        V22_BASIC(String.valueOf("v22Basic")),
        V22_EN16931(String.valueOf("v22EN16931")),
        V22_EXTENDED(String.valueOf("v22Extended")),
        V22_X_RECHNUNG(String.valueOf("v22XRechnung")),
        V23_MINIMUM(String.valueOf("v23Minimum")),
        V23_BASIC_WL(String.valueOf("v23BasicWL")),
        V23_BASIC(String.valueOf("v23Basic")),
        V23_EN16931(String.valueOf("v23EN16931")),
        V23_EXTENDED(String.valueOf("v23Extended")),
        V23_X_RECHNUNG(String.valueOf("v23XRechnung"));

        private String value;

        private VersionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VersionEnum fromValue(String value) {
            for (VersionEnum b : VersionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SourceEnum {
        VALUE(String.valueOf("value")),
        URI(String.valueOf("uri"));

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceEnum fromValue(String value) {
            for (SourceEnum b : SourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

