/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to set the position of the watermark in the PDF document.")
@JsonPropertyOrder(value={"aspectRatio", "height", "metrics", "position", "width", "x", "y"})
@JsonTypeName(value="Operation_WatermarkPosition")
public class OperationWatermarkPosition {
    public static final String JSON_PROPERTY_ASPECT_RATIO = "aspectRatio";
    private Boolean aspectRatio = true;
    public static final String JSON_PROPERTY_HEIGHT = "height";
    private Integer height = 0;
    public static final String JSON_PROPERTY_METRICS = "metrics";
    private MetricsEnum metrics = MetricsEnum.MM;
    public static final String JSON_PROPERTY_POSITION = "position";
    private PositionEnum position = PositionEnum.CENTER_CENTER;
    public static final String JSON_PROPERTY_WIDTH = "width";
    private Integer width = 0;
    public static final String JSON_PROPERTY_X = "x";
    private Integer x = 0;
    public static final String JSON_PROPERTY_Y = "y";
    private Integer y = 0;

    public OperationWatermarkPosition aspectRatio(Boolean aspectRatio) {
        this.aspectRatio = aspectRatio;
        return this;
    }

    @Schema(name="Forces the aspect ratio to be maintained when a watermark is scaled if \"width\" and \"height\" are specified.")
    @JsonProperty(value="aspectRatio")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getAspectRatio() {
        return this.aspectRatio;
    }

    @JsonProperty(value="aspectRatio")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAspectRatio(Boolean aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    public OperationWatermarkPosition height(Integer height) {
        this.height = height;
        return this;
    }

    @Schema(name="Forces the specified height for the watermark if the values are not equal 0. In this case, the watermark will be scaled inside the area, which may result in the image losing quality or being distorted (please refer to \"aspectRatio\" as well)")
    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getHeight() {
        return this.height;
    }

    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeight(Integer height) {
        this.height = height;
    }

    public OperationWatermarkPosition metrics(MetricsEnum metrics) {
        this.metrics = metrics;
        return this;
    }

    @Schema(name="Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt = Points(1/72 inch) *   pc = Picas(12 points) *   px = Pixels(1/96 inch) *   mm = Millimeters *   in = Inches")
    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetricsEnum getMetrics() {
        return this.metrics;
    }

    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetrics(MetricsEnum metrics) {
        this.metrics = metrics;
    }

    public OperationWatermarkPosition position(PositionEnum position) {
        this.position = position;
        return this;
    }

    @Schema(name="Uses one of multiple preset positions in order to position the watermark on the page.  *   custom = Disable the use of a preset position. *   top\\_left = Positions the watermark in the upper left corner. *   top\\_center = Positions the watermark in the centre at the top margin. *   top\\_right = Positions the watermark in the top right corner. *   center\\_left = Positions the watermark at the centre of the page, to the left. *   center\\_center = Positions the watermark at the centre of the page. *   center\\_right = Positions the watermark at the centre of the page, to the right. *   bottom\\_left = Positions the watermark in the bottom left corner. *   bottom\\_center = Positions the watermark in the centre at the bottom margin. *   bottom\\_right = Positions the watermark in the bottom right corner.")
    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public PositionEnum getPosition() {
        return this.position;
    }

    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPosition(PositionEnum position) {
        this.position = position;
    }

    public OperationWatermarkPosition width(Integer width) {
        this.width = width;
        return this;
    }

    @Schema(name="Forces the specified width for the watermark if the values are not equal 0. In this case, the watermark will be scaled inside the area, which may result in the image losing quality or being distorted (please refer to \"aspectRatio\" as well)")
    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getWidth() {
        return this.width;
    }

    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWidth(Integer width) {
        this.width = width;
    }

    public OperationWatermarkPosition x(Integer x) {
        this.x = x;
        return this;
    }

    @Schema(name="Used to define the X-axis position (as per metrics), starting from the top left corner of the PDF document, if position is set to \"custom.\". If \"position is set to a different value, these arguments will be interpreted as \"offsets\" from the selected position. This specification applies for both the text and image output.")
    @JsonProperty(value="x")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getX() {
        return this.x;
    }

    @JsonProperty(value="x")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setX(Integer x) {
        this.x = x;
    }

    public OperationWatermarkPosition y(Integer y) {
        this.y = y;
        return this;
    }

    @Schema(name="Used to define the Y-axis position (as per metrics), starting from the top left corner of the PDF document, if position is set to \"custom.\". If \"position is set to a different value, these arguments will be interpreted as \"offsets\" from the selected position. This specification applies for both the text and image output.")
    @JsonProperty(value="y")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getY() {
        return this.y;
    }

    @JsonProperty(value="y")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setY(Integer y) {
        this.y = y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationWatermarkPosition operationWatermarkPosition = (OperationWatermarkPosition)o;
        return Objects.equals(this.aspectRatio, operationWatermarkPosition.aspectRatio) && Objects.equals(this.height, operationWatermarkPosition.height) && Objects.equals((Object)this.metrics, (Object)operationWatermarkPosition.metrics) && Objects.equals((Object)this.position, (Object)operationWatermarkPosition.position) && Objects.equals(this.width, operationWatermarkPosition.width) && Objects.equals(this.x, operationWatermarkPosition.x) && Objects.equals(this.y, operationWatermarkPosition.y);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aspectRatio, this.height, this.metrics, this.position, this.width, this.x, this.y});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationWatermarkPosition {\n");
        sb.append("    aspectRatio: ").append(this.toIndentedString(this.aspectRatio)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString((Object)this.metrics)).append("\n");
        sb.append("    position: ").append(this.toIndentedString((Object)this.position)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    x: ").append(this.toIndentedString(this.x)).append("\n");
        sb.append("    y: ").append(this.toIndentedString(this.y)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PositionEnum {
        CUSTOM(String.valueOf("custom")),
        TOP_LEFT(String.valueOf("top_left")),
        TOP_CENTER(String.valueOf("top_center")),
        TOP_RIGHT(String.valueOf("top_right")),
        CENTER_LEFT(String.valueOf("center_left")),
        CENTER_CENTER(String.valueOf("center_center")),
        CENTER_RIGHT(String.valueOf("center_right")),
        BOTTOM_LEFT(String.valueOf("bottom_left")),
        BOTTOM_CENTER(String.valueOf("bottom_center")),
        BOTTOM_RIGHT(String.valueOf("bottom_right"));

        private String value;

        private PositionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PositionEnum fromValue(String value) {
            for (PositionEnum b : PositionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum MetricsEnum {
        PT(String.valueOf("pt")),
        PC(String.valueOf("pc")),
        PX(String.valueOf("px")),
        MM(String.valueOf("mm")),
        IN(String.valueOf("in"));

        private String value;

        private MetricsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MetricsEnum fromValue(String value) {
            for (MetricsEnum b : MetricsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

