/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationWatermarkFileData;
import net.webpdf.wsclient.openapi.OperationWatermarkPosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to add an image as a watermark.")
@JsonPropertyOrder(value={"data", "opacity", "position", "scale"})
@JsonTypeName(value="Operation_WatermarkImage")
public class OperationWatermarkImage {
    public static final String JSON_PROPERTY_DATA = "data";
    private OperationWatermarkFileData data;
    public static final String JSON_PROPERTY_OPACITY = "opacity";
    private Integer opacity = 25;
    public static final String JSON_PROPERTY_POSITION = "position";
    private OperationWatermarkPosition position;
    public static final String JSON_PROPERTY_SCALE = "scale";
    private Integer scale = 0;

    public OperationWatermarkImage data(OperationWatermarkFileData data) {
        this.data = data;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public OperationWatermarkFileData getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setData(OperationWatermarkFileData data) {
        this.data = data;
    }

    public OperationWatermarkImage opacity(Integer opacity) {
        this.opacity = opacity;
        return this;
    }

    @Schema(name="Used to set the image's opacity. A percent value between 0 and 100 is allowed, whereby 0 equals the minimum opacity. The higher the value, the more the content of the PDF document will be covered over.")
    @JsonProperty(value="opacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getOpacity() {
        return this.opacity;
    }

    @JsonProperty(value="opacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOpacity(Integer opacity) {
        this.opacity = opacity;
    }

    public OperationWatermarkImage position(OperationWatermarkPosition position) {
        this.position = position;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationWatermarkPosition getPosition() {
        return this.position;
    }

    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPosition(OperationWatermarkPosition position) {
        this.position = position;
    }

    public OperationWatermarkImage scale(Integer scale) {
        this.scale = scale;
        return this;
    }

    @Schema(name="Specifies the scaling of the image in percent.")
    @JsonProperty(value="scale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getScale() {
        return this.scale;
    }

    @JsonProperty(value="scale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationWatermarkImage operationWatermarkImage = (OperationWatermarkImage)o;
        return Objects.equals(this.data, operationWatermarkImage.data) && Objects.equals(this.opacity, operationWatermarkImage.opacity) && Objects.equals(this.position, operationWatermarkImage.position) && Objects.equals(this.scale, operationWatermarkImage.scale);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.opacity, this.position, this.scale);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationWatermarkImage {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    opacity: ").append(this.toIndentedString(this.opacity)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    scale: ").append(this.toIndentedString(this.scale)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

