/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="The setTransition action shows the changes that result from the actions with the use of the defined transition animation.")
@JsonPropertyOrder(value={"direction", "duration", "effectDimensionHorizontal", "flyAreaOpaque", "flyScale", "motionInward", "scaling", "style"})
@JsonTypeName(value="Operation_TransitionAction_setTransition")
public class OperationTransitionActionSetTransition {
    public static final String JSON_PROPERTY_DIRECTION = "direction";
    private DirectionEnum direction = DirectionEnum.LEFT_TO_RIGHT;
    public static final String JSON_PROPERTY_DURATION = "duration";
    private Float duration = Float.valueOf(1.0f);
    public static final String JSON_PROPERTY_EFFECT_DIMENSION_HORIZONTAL = "effectDimensionHorizontal";
    private Boolean effectDimensionHorizontal = true;
    public static final String JSON_PROPERTY_FLY_AREA_OPAQUE = "flyAreaOpaque";
    private Boolean flyAreaOpaque = false;
    public static final String JSON_PROPERTY_FLY_SCALE = "flyScale";
    private Integer flyScale = 100;
    public static final String JSON_PROPERTY_MOTION_INWARD = "motionInward";
    private Boolean motionInward = true;
    public static final String JSON_PROPERTY_SCALING = "scaling";
    private Integer scaling = 100;
    public static final String JSON_PROPERTY_STYLE = "style";
    private StyleEnum style = StyleEnum.NONE;

    public OperationTransitionActionSetTransition direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @Schema(name="The direction of the transition animation (provided that it can be applied to the animation).  *   leftToRight = From left to right *   bottomToTop = From bottom to top *   rightToLeft = From right to left *   topToBottom = From top to bottom *   topLeftToBottomRight = From top left to bottom right *   none = Use the default value for the animation")
    @JsonProperty(value="direction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public DirectionEnum getDirection() {
        return this.direction;
    }

    @JsonProperty(value="direction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public OperationTransitionActionSetTransition duration(Float duration) {
        this.duration = duration;
        return this;
    }

    @Schema(name="The page transition animation's duration, in seconds. Make sure to avoid excessively high values, as certain reader programs will force the entire animation to be displayed without any option for interrupting it. Moreover, an excessively long animation can result in display and execution errors in the reader program. Values under 10 seconds are recommended.")
    @JsonProperty(value="duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getDuration() {
        return this.duration;
    }

    @JsonProperty(value="duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDuration(Float duration) {
        this.duration = duration;
    }

    public OperationTransitionActionSetTransition effectDimensionHorizontal(Boolean effectDimensionHorizontal) {
        this.effectDimensionHorizontal = effectDimensionHorizontal;
        return this;
    }

    @Schema(name="Option for the split and blinds animation styles - used to define the axis along which the effect should happen. true corresponds to the horizontal axis; false to the vertical one.")
    @JsonProperty(value="effectDimensionHorizontal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getEffectDimensionHorizontal() {
        return this.effectDimensionHorizontal;
    }

    @JsonProperty(value="effectDimensionHorizontal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEffectDimensionHorizontal(Boolean effectDimensionHorizontal) {
        this.effectDimensionHorizontal = effectDimensionHorizontal;
    }

    public OperationTransitionActionSetTransition flyAreaOpaque(Boolean flyAreaOpaque) {
        this.flyAreaOpaque = flyAreaOpaque;
        return this;
    }

    @Schema(name="Option for the \"fly\" animation style - used to define whether the page background for the page that flies in should be transparent initially.")
    @JsonProperty(value="flyAreaOpaque")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getFlyAreaOpaque() {
        return this.flyAreaOpaque;
    }

    @JsonProperty(value="flyAreaOpaque")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFlyAreaOpaque(Boolean flyAreaOpaque) {
        this.flyAreaOpaque = flyAreaOpaque;
    }

    public OperationTransitionActionSetTransition flyScale(Integer flyScale) {
        this.flyScale = flyScale;
        return this;
    }

    @Schema(name="Option for the \"fly\" animation style - used to define the starting scale for the page that flies in. The page will smoothly be scaled from this starting scale all the way to the size of the page being displayed (defined as a percentage).")
    @JsonProperty(value="flyScale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getFlyScale() {
        return this.flyScale;
    }

    @JsonProperty(value="flyScale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFlyScale(Integer flyScale) {
        this.flyScale = flyScale;
    }

    public OperationTransitionActionSetTransition motionInward(Boolean motionInward) {
        this.motionInward = motionInward;
        return this;
    }

    @Schema(name="Option for the split, box, and fly animation styles - defines whether the animation direction will be from the edges of the page towards the centre (true) or from the centre towards the edges (false).")
    @JsonProperty(value="motionInward")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getMotionInward() {
        return this.motionInward;
    }

    @JsonProperty(value="motionInward")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMotionInward(Boolean motionInward) {
        this.motionInward = motionInward;
    }

    public OperationTransitionActionSetTransition scaling(Integer scaling) {
        this.scaling = scaling;
        return this;
    }

    @Schema(name="Used to set the value for zooming (as a percentage).")
    @JsonProperty(value="scaling")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getScaling() {
        return this.scaling;
    }

    @JsonProperty(value="scaling")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScaling(Integer scaling) {
        this.scaling = scaling;
    }

    public OperationTransitionActionSetTransition style(StyleEnum style) {
        this.style = style;
        return this;
    }

    @Schema(name="The style of transition animation.  *   blinds = Crossfades *   box = Crossfades in a rectangular pattern *   cover = Covers *   dissolve = Dissolves *   fade = Fades *   fly = Page flies in *   glitter = Page dissolves and is replaced *   push = Page is pushed out *   split = Splits page *   uncover = Uncovers page *   wipe = Wipes page *   none = No special effect")
    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public StyleEnum getStyle() {
        return this.style;
    }

    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStyle(StyleEnum style) {
        this.style = style;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationTransitionActionSetTransition operationTransitionActionSetTransition = (OperationTransitionActionSetTransition)o;
        return Objects.equals((Object)this.direction, (Object)operationTransitionActionSetTransition.direction) && Objects.equals(this.duration, operationTransitionActionSetTransition.duration) && Objects.equals(this.effectDimensionHorizontal, operationTransitionActionSetTransition.effectDimensionHorizontal) && Objects.equals(this.flyAreaOpaque, operationTransitionActionSetTransition.flyAreaOpaque) && Objects.equals(this.flyScale, operationTransitionActionSetTransition.flyScale) && Objects.equals(this.motionInward, operationTransitionActionSetTransition.motionInward) && Objects.equals(this.scaling, operationTransitionActionSetTransition.scaling) && Objects.equals((Object)this.style, (Object)operationTransitionActionSetTransition.style);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.direction, this.duration, this.effectDimensionHorizontal, this.flyAreaOpaque, this.flyScale, this.motionInward, this.scaling, this.style});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationTransitionActionSetTransition {\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    effectDimensionHorizontal: ").append(this.toIndentedString(this.effectDimensionHorizontal)).append("\n");
        sb.append("    flyAreaOpaque: ").append(this.toIndentedString(this.flyAreaOpaque)).append("\n");
        sb.append("    flyScale: ").append(this.toIndentedString(this.flyScale)).append("\n");
        sb.append("    motionInward: ").append(this.toIndentedString(this.motionInward)).append("\n");
        sb.append("    scaling: ").append(this.toIndentedString(this.scaling)).append("\n");
        sb.append("    style: ").append(this.toIndentedString((Object)this.style)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StyleEnum {
        BLINDS(String.valueOf("blinds")),
        BOX(String.valueOf("box")),
        COVER(String.valueOf("cover")),
        DISSOLVE(String.valueOf("dissolve")),
        FADE(String.valueOf("fade")),
        FLY(String.valueOf("fly")),
        GLITTER(String.valueOf("glitter")),
        PUSH(String.valueOf("push")),
        SPLIT(String.valueOf("split")),
        UNCOVER(String.valueOf("uncover")),
        WIPE(String.valueOf("wipe")),
        NONE(String.valueOf("none"));

        private String value;

        private StyleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StyleEnum fromValue(String value) {
            for (StyleEnum b : StyleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DirectionEnum {
        LEFT_TO_RIGHT(String.valueOf("leftToRight")),
        BOTTOM_TO_TOP(String.valueOf("bottomToTop")),
        RIGHT_TO_LEFT(String.valueOf("rightToLeft")),
        TOP_TO_BOTTOM(String.valueOf("topToBottom")),
        TOP_LEFT_TO_BOTTOM_RIGHT(String.valueOf("topLeftToBottomRight")),
        NONE(String.valueOf("none"));

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DirectionEnum fromValue(String value) {
            for (DirectionEnum b : DirectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

